/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.config.reflection;

import com.swirlds.common.utility.CommonUtils;
import com.swirlds.config.api.ConfigData;
import com.swirlds.config.api.ConfigProperty;
import com.swirlds.config.api.Configuration;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ConfigReflectionUtils {
    private ConfigReflectionUtils() {
    }

    public static Type getSingleGenericTypeArgument(ParameterizedType parameterizedType) {
        if (parameterizedType.getActualTypeArguments().length != 1) {
            throw new IllegalArgumentException("Only exactly 1 generic type is supported");
        }
        return parameterizedType.getActualTypeArguments()[0];
    }

    public static boolean isPublic(Class<?> type) {
        return Modifier.isPublic(type.getModifiers());
    }

    public static String getPropertyNameForConfigDataProperty(String prefix, RecordComponent component) {
        return Optional.ofNullable(component.getAnnotation(ConfigProperty.class)).map(propertyAnnotation -> {
            if (!propertyAnnotation.value().isBlank()) {
                return ConfigReflectionUtils.getPropertyNameForConfigDataProperty(prefix, propertyAnnotation.value());
            }
            return ConfigReflectionUtils.getPropertyNameForConfigDataProperty(prefix, component.getName());
        }).orElseGet(() -> ConfigReflectionUtils.getPropertyNameForConfigDataProperty(prefix, component.getName()));
    }

    public static String getPropertyNameForConfigDataProperty(String prefix, String name) {
        if (prefix.isBlank()) {
            return name;
        }
        return prefix + "." + name;
    }

    public static String getNamePrefixForConfigDataRecord(AnnotatedElement type) {
        return Optional.ofNullable(type.getAnnotation(ConfigData.class)).map(ConfigData::value).orElse("");
    }

    public static <A extends Annotation, V> List<AnnotatedProperty<A, V>> getAllMatchingPropertiesForConstraintAnnotation(Class<A> constraintAnnotationType, Configuration configuration) {
        CommonUtils.throwArgNull(constraintAnnotationType, "annotationType");
        CommonUtils.throwArgNull(configuration, "configuration");
        return configuration.getConfigDataTypes().stream().flatMap(recordType -> Arrays.stream(recordType.getRecordComponents())).filter(component -> component.isAnnotationPresent(constraintAnnotationType)).map(component -> ConfigReflectionUtils.createData(constraintAnnotationType, configuration, component)).collect(Collectors.toList());
    }

    private static <A extends Annotation, V> AnnotatedProperty<A, V> createData(Class<A> annotationType, Configuration configuration, RecordComponent component) {
        try {
            A annotation = component.getAnnotation(annotationType);
            Class<?> recordType = component.getDeclaringRecord();
            String propertyNamePrefix = ConfigReflectionUtils.getNamePrefixForConfigDataRecord(recordType);
            Record recordInstance = configuration.getConfigData(recordType);
            Object propertyValue = component.getAccessor().invoke((Object)recordInstance, new Object[0]);
            String propertyName = ConfigReflectionUtils.getPropertyNameForConfigDataProperty(propertyNamePrefix, component);
            Class<?> propertyType = component.getType();
            return new AnnotatedProperty<A, Object>(annotation, component, propertyName, propertyValue, propertyType);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("Can not get the needed metadata for the given type", e);
        }
    }

    public record AnnotatedProperty<A extends Annotation, V>(A annotation, RecordComponent component, String propertyName, V propertyValue, Class<V> propertyType) {
    }
}

