/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.config.sources;

import com.swirlds.common.config.sources.AbstractConfigSource;
import com.swirlds.common.utility.CommonUtils;
import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.logging.LogMarker;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AliasConfigSource
extends AbstractConfigSource {
    private static final Logger logger = LogManager.getLogger(AliasConfigSource.class);
    private final ConfigSource wrappedSource;
    private final Queue<Alias> aliases;
    private Map<String, String> properties;

    public AliasConfigSource(ConfigSource wrappedSource) {
        this.wrappedSource = CommonUtils.throwArgNull(wrappedSource, "wrappedSource");
        this.aliases = new ConcurrentLinkedQueue<Alias>();
    }

    public void addAlias(String alias, String originalName) {
        this.aliases.add(new Alias(alias, originalName));
    }

    @Override
    protected Map<String, String> getInternalProperties() {
        if (this.properties == null) {
            Map internalProperties = this.wrappedSource.getProperties();
            HashMap aliasProperties = new HashMap();
            this.aliases.forEach(alias -> {
                if (internalProperties.containsKey(alias.alias)) {
                    logger.error(LogMarker.CONFIG.getMarker(), "Will not create alias {} since property '{}' already exits", alias, (Object)alias.alias);
                } else if (aliasProperties.containsKey(alias.alias)) {
                    logger.error(LogMarker.CONFIG.getMarker(), "Will not create alias {} since alias '{}' already exits", alias, (Object)alias.alias);
                } else if (!internalProperties.containsKey(alias.originalName)) {
                    logger.error(LogMarker.CONFIG.getMarker(), "Will not create alias {} since property '{}' does not exits", alias, (Object)alias.originalName);
                } else {
                    aliasProperties.put(alias.alias, (String)internalProperties.get(alias.originalName));
                    logger.debug(LogMarker.CONFIG.getMarker(), "Added alias {}", alias);
                }
            });
            this.properties = new HashMap<String, String>();
            this.properties.putAll(internalProperties);
            this.properties.putAll(aliasProperties);
        }
        return Collections.unmodifiableMap(this.properties);
    }

    public int getOrdinal() {
        return this.wrappedSource.getOrdinal();
    }

    private record Alias(String alias, String originalName) {
        private Alias {
            CommonUtils.throwArgBlank(alias, "alias");
            CommonUtils.throwArgBlank(originalName, "originalName");
            if (Objects.equals(originalName, alias)) {
                logger.warn(LogMarker.CONFIG.getMarker(), "originalName and alias are the same ({})! Will not create an alias", (Object)alias);
            }
        }

        @Override
        public String toString() {
            return "'" + this.alias + "'->'" + this.originalName + "'";
        }
    }
}

