/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.config.sources;

import com.swirlds.common.config.sources.AbstractConfigSource;
import com.swirlds.common.utility.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

@Deprecated(forRemoval=true)
public class LegacyFileConfigSource
extends AbstractConfigSource {
    private final Map<String, String> internalProperties;
    private final Path filePath;
    private final int ordinal;

    public static LegacyFileConfigSource ofSettingsFile() throws IOException {
        Path path = FileSystems.getDefault().getPath("settings.txt", new String[0]).toAbsolutePath().normalize();
        return new LegacyFileConfigSource(path, 110);
    }

    public static LegacyFileConfigSource ofConfigFile() throws IOException {
        Path path = FileSystems.getDefault().getPath("config.txt", new String[0]).toAbsolutePath().normalize();
        return new LegacyFileConfigSource(path, 120);
    }

    public LegacyFileConfigSource(Path filePath) throws IOException {
        this(filePath, 100);
    }

    public LegacyFileConfigSource(Path filePath, int ordinal) throws IOException {
        this.filePath = CommonUtils.throwArgNull(filePath, "filePath");
        this.ordinal = ordinal;
        this.internalProperties = Collections.unmodifiableMap(LegacyFileConfigSource.loadSettings(filePath.toFile()));
    }

    public LegacyFileConfigSource(String filePath) throws IOException {
        this(Paths.get(CommonUtils.throwArgBlank(filePath, "filePath"), new String[0]));
    }

    private static Map<String, String> loadSettings(File settingsFile) throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (!settingsFile.exists()) {
            return properties;
        }
        try (Stream<String> stream = Files.lines(settingsFile.toPath());){
            stream.map(line -> {
                int pos = line.indexOf("#");
                if (pos > -1) {
                    return line.substring(0, pos).trim();
                }
                return line.trim();
            }).filter(line -> !line.isEmpty()).filter(line -> LegacyFileConfigSource.splitLine(line).length > 0).forEach(line -> {
                String[] pars = LegacyFileConfigSource.splitLine(line);
                try {
                    if (pars.length > 1) {
                        String[] params = new String[pars.length - 1];
                        StringBuilder stringBuilder = new StringBuilder();
                        for (int i = 1; i < pars.length; ++i) {
                            stringBuilder.append(pars[i].trim());
                            if (i == pars.length - 1) continue;
                            stringBuilder.append(",");
                        }
                        properties.put(pars[0], stringBuilder.toString());
                    } else {
                        properties.put(pars[0], "");
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException("syntax error in settings file", e);
                }
            });
        }
        return properties;
    }

    private static String[] splitLine(String line) {
        return (String[])Arrays.stream(line.split(",")).map(e -> e.trim()).toArray(String[]::new);
    }

    @Override
    protected Map<String, String> getInternalProperties() {
        return Collections.unmodifiableMap(this.internalProperties);
    }

    public String getName() {
        return "Swirlds Legacy Settings loader for " + this.filePath;
    }

    public int getOrdinal() {
        return this.ordinal;
    }
}

