/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.config.sources;

import com.swirlds.common.config.sources.AbstractConfigSource;
import com.swirlds.common.utility.CommonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertyFileConfigSource
extends AbstractConfigSource {
    private final Map<String, String> internalProperties;
    private final Path filePath;

    public PropertyFileConfigSource(Path filePath) throws IOException {
        this.filePath = CommonUtils.throwArgNull(filePath, "filePath");
        this.internalProperties = new HashMap<String, String>();
        try (BufferedReader reader = Files.newBufferedReader(filePath);){
            Properties loadedProperties = new Properties();
            loadedProperties.load(reader);
            loadedProperties.stringPropertyNames().forEach(name -> this.internalProperties.put((String)name, loadedProperties.getProperty((String)name)));
        }
    }

    public String getName() {
        return "Property file config source for " + this.filePath;
    }

    @Override
    protected Map<String, String> getInternalProperties() {
        return Collections.unmodifiableMap(this.internalProperties);
    }

    public int getOrdinal() {
        return 200;
    }
}

