/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.context.internal;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.crypto.Cryptography;
import com.swirlds.common.crypto.CryptographyHolder;
import com.swirlds.common.metrics.Metrics;
import com.swirlds.common.metrics.MetricsProvider;
import com.swirlds.common.system.NodeId;
import com.swirlds.common.utility.CommonUtils;
import com.swirlds.config.api.Configuration;

public final class DefaultPlatformContext
implements PlatformContext {
    private final Configuration configuration;
    private final Metrics metrics;
    private final Cryptography cryptography;

    public DefaultPlatformContext(NodeId nodeId, MetricsProvider metricsProvider, Configuration configuration) {
        this.configuration = CommonUtils.throwArgNull(configuration, "configuration");
        this.metrics = CommonUtils.throwArgNull(metricsProvider, "metricsProvider").createPlatformMetrics(nodeId);
        this.cryptography = CryptographyHolder.get();
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Cryptography getCryptography() {
        return this.cryptography;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }
}

