/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto;

import com.swirlds.common.crypto.SignatureType;
import com.swirlds.common.crypto.VerificationStatus;
import com.swirlds.common.internal.HashUtils;
import com.swirlds.common.io.exceptions.BadIOException;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Future;

public class TransactionSignature
implements Comparable<TransactionSignature> {
    private final byte[] contents;
    private final byte[] expandedPublicKey;
    private final int messageOffset;
    private final int messageLength;
    private final int publicKeyOffset;
    private final int publicKeyLength;
    private final int signatureOffset;
    private final int signatureLength;
    private final SignatureType signatureType;
    private VerificationStatus signatureStatus;
    private volatile transient Future<Void> future;

    public TransactionSignature(byte[] contents, int signatureOffset, int signatureLength, int publicKeyOffset, int publicKeyLength, int messageOffset, int messageLength) {
        this(contents, signatureOffset, signatureLength, publicKeyOffset, publicKeyLength, messageOffset, messageLength, SignatureType.ED25519);
    }

    public TransactionSignature(byte[] contents, int signatureOffset, int signatureLength, byte[] expandedPublicKey, int publicKeyOffset, int publicKeyLength, int messageOffset, int messageLength) {
        this(contents, signatureOffset, signatureLength, expandedPublicKey, publicKeyOffset, publicKeyLength, messageOffset, messageLength, SignatureType.ED25519);
    }

    public TransactionSignature(byte[] contents, int signatureOffset, int signatureLength, int publicKeyOffset, int publicKeyLength, int messageOffset, int messageLength, SignatureType signatureType) {
        this(contents, signatureOffset, signatureLength, null, publicKeyOffset, publicKeyLength, messageOffset, messageLength, signatureType);
    }

    public TransactionSignature(byte[] contents, int signatureOffset, int signatureLength, byte[] expandedPublicKey, int publicKeyOffset, int publicKeyLength, int messageOffset, int messageLength, SignatureType signatureType) {
        byte[] publicKeySource;
        if (contents == null || contents.length == 0) {
            throw new NullPointerException("contents");
        }
        byte[] byArray = publicKeySource = expandedPublicKey != null ? expandedPublicKey : contents;
        if (signatureOffset < 0 || signatureOffset > contents.length) {
            throw new IllegalArgumentException("signatureOffset");
        }
        if (signatureLength < 0 || signatureLength > contents.length || signatureLength + signatureOffset > contents.length) {
            throw new IllegalArgumentException("signatureLength");
        }
        if (publicKeyOffset < 0 || publicKeyOffset > publicKeySource.length) {
            throw new IllegalArgumentException("publicKeyOffset");
        }
        if (publicKeyLength < 0 || publicKeyLength > publicKeySource.length || publicKeyLength + publicKeyOffset > publicKeySource.length) {
            throw new IllegalArgumentException("publicKeyLength");
        }
        if (messageOffset < 0 || messageOffset > contents.length) {
            throw new IllegalArgumentException("messageOffset");
        }
        if (messageLength < 0 || messageLength > contents.length || messageLength + messageOffset > contents.length) {
            throw new IllegalArgumentException("messageLength");
        }
        this.contents = contents;
        this.expandedPublicKey = expandedPublicKey;
        this.signatureOffset = signatureOffset;
        this.signatureLength = signatureLength;
        this.publicKeyOffset = publicKeyOffset;
        this.publicKeyLength = publicKeyLength;
        this.messageOffset = messageOffset;
        this.messageLength = messageLength;
        this.signatureType = signatureType;
        this.signatureStatus = VerificationStatus.UNKNOWN;
    }

    public TransactionSignature(TransactionSignature other, int publicKeyOffset, int publicKeyLength, int messageOffset, int messageLength) {
        this(other, null, publicKeyOffset, publicKeyLength, messageOffset, messageLength);
    }

    public TransactionSignature(TransactionSignature other, byte[] expandedPublicKey, int publicKeyOffset, int publicKeyLength, int messageOffset, int messageLength) {
        byte[] publicKeySource;
        if (other == null) {
            throw new NullPointerException("other");
        }
        byte[] byArray = publicKeySource = expandedPublicKey != null ? expandedPublicKey : other.contents;
        if (publicKeyOffset < 0 || publicKeyOffset > publicKeySource.length) {
            throw new IllegalArgumentException("publicKeyOffset");
        }
        if (publicKeyLength < 0 || publicKeyLength > publicKeySource.length || publicKeyLength + publicKeyOffset > publicKeySource.length) {
            throw new IllegalArgumentException("publicKeyLength");
        }
        if (messageOffset < 0 || messageOffset > other.contents.length) {
            throw new IllegalArgumentException("messageOffset");
        }
        if (messageLength < 0 || messageLength > other.contents.length || messageLength + messageOffset > other.contents.length) {
            throw new IllegalArgumentException("messageLength");
        }
        this.contents = other.contents;
        this.signatureOffset = other.signatureOffset;
        this.signatureLength = other.signatureLength;
        this.expandedPublicKey = expandedPublicKey;
        this.publicKeyOffset = publicKeyOffset;
        this.publicKeyLength = publicKeyLength;
        this.messageOffset = messageOffset;
        this.messageLength = messageLength;
        this.signatureType = other.signatureType;
        this.signatureStatus = other.signatureStatus;
    }

    public TransactionSignature(TransactionSignature other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        this.contents = other.contents;
        this.expandedPublicKey = other.expandedPublicKey;
        this.signatureOffset = other.signatureOffset;
        this.signatureLength = other.signatureLength;
        this.publicKeyOffset = other.publicKeyOffset;
        this.publicKeyLength = other.publicKeyLength;
        this.messageOffset = other.messageOffset;
        this.messageLength = other.messageLength;
        this.signatureType = other.signatureType;
        this.signatureStatus = other.signatureStatus;
    }

    private static void serialize(TransactionSignature signature, DataOutputStream dos, int[] byteCount) throws IOException {
        if (signature == null) {
            throw new NullPointerException("signature");
        }
        if (dos == null) {
            throw new NullPointerException("dos");
        }
        int sigType = signature.signatureType.ordinal();
        dos.writeInt(signature.signatureLength);
        dos.writeInt(439 - signature.signatureLength);
        dos.writeInt(sigType);
        dos.write(signature.contents, signature.signatureOffset, signature.signatureLength);
        dos.writeInt(signature.publicKeyLength);
        dos.writeInt(541 - signature.publicKeyLength);
        dos.write(signature.expandedPublicKey != null ? signature.expandedPublicKey : signature.contents, signature.publicKeyOffset, signature.publicKeyLength);
        dos.writeInt(signature.messageLength);
        dos.writeInt(647 - signature.messageLength);
        dos.write(signature.contents, signature.messageOffset, signature.messageLength);
        if (byteCount != null && byteCount.length > 0) {
            byteCount[0] = byteCount[0] + (28 + signature.signatureLength * 1 + signature.publicKeyLength * 1 + signature.messageLength * 1);
        }
    }

    public static TransactionSignature deserialize(SerializableDataInputStream dis, int[] byteCount) throws IOException {
        if (dis == null) {
            throw new NullPointerException("dis");
        }
        int[] totalBytes = new int[]{28};
        int sigLen = dis.readInt();
        int sigChecksum = dis.readInt();
        if (sigLen < 0 || sigChecksum != 439 - sigLen) {
            throw new BadIOException("Signature.deserialize tried to create signature array of length " + sigLen + " with wrong checksum.");
        }
        SignatureType sigType = SignatureType.from(dis.readInt(), SignatureType.ED25519);
        byte[] sig = new byte[sigLen];
        dis.readFully(sig);
        totalBytes[0] = totalBytes[0] + sig.length;
        int pkLen = dis.readInt();
        int pkChecksum = dis.readInt();
        if (pkLen < 0 || pkChecksum != 541 - pkLen) {
            throw new BadIOException("Signature.deserialize tried to create public key array of length " + pkLen + " with wrong checksum.");
        }
        byte[] pk = new byte[pkLen];
        if (pkLen > 0) {
            dis.readFully(pk);
            totalBytes[0] = totalBytes[0] + pk.length;
        }
        int msgLen = dis.readInt();
        int msgChecksum = dis.readInt();
        if (msgLen < 0 || msgChecksum != 647 - msgLen) {
            throw new BadIOException("Signature.deserialize tried to create message array of length " + pkLen + " with wrong checksum.");
        }
        byte[] msg = new byte[msgLen];
        if (msgLen > 0) {
            dis.readFully(msg);
            totalBytes[0] = totalBytes[0] + msg.length;
        }
        if (byteCount != null && byteCount.length > 0) {
            byteCount[0] = byteCount[0] + totalBytes[0];
        }
        ByteBuffer buffer = ByteBuffer.allocate(msgLen + pkLen + sigLen);
        buffer.put(msg);
        buffer.put(pk);
        buffer.put(sig);
        return new TransactionSignature(buffer.array(), msg.length + pk.length, sig.length, msg.length, pk.length, 0, msg.length, sigType);
    }

    public byte[] getContents() {
        return this.contents != null ? (byte[])this.contents.clone() : null;
    }

    public byte[] getContentsDirect() {
        return this.contents;
    }

    public byte[] getExpandedPublicKey() {
        return this.expandedPublicKey != null ? (byte[])this.expandedPublicKey.clone() : null;
    }

    public byte[] getExpandedPublicKeyDirect() {
        return this.expandedPublicKey;
    }

    public int getMessageOffset() {
        return this.messageOffset;
    }

    public int getMessageLength() {
        return this.messageLength;
    }

    public int getPublicKeyOffset() {
        return this.publicKeyOffset;
    }

    public int getPublicKeyLength() {
        return this.publicKeyLength;
    }

    public int getSignatureOffset() {
        return this.signatureOffset;
    }

    public int getSignatureLength() {
        return this.signatureLength;
    }

    public synchronized Future<Void> getFuture() {
        return this.future;
    }

    public synchronized void setFuture(Future<Void> future) {
        this.future = future;
        this.notifyAll();
    }

    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public VerificationStatus getSignatureStatus() {
        return this.signatureStatus;
    }

    public void setSignatureStatus(VerificationStatus signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    public synchronized Future<Void> waitForFuture() throws InterruptedException {
        while (this.future == null) {
            this.wait();
        }
        return this.future;
    }

    public void computeDigest(MessageDigest digest) {
        if (digest == null) {
            throw new NullPointerException("digest");
        }
        HashUtils.update(digest, this.signatureType.ordinal());
        HashUtils.update(digest, this.contents, this.signatureOffset, this.signatureLength);
        HashUtils.update(digest, this.expandedPublicKey != null ? this.expandedPublicKey : this.contents, this.publicKeyOffset, this.publicKeyLength);
        HashUtils.update(digest, this.contents, this.messageOffset, this.messageLength);
    }

    public int writeTo(DataOutputStream dos, int[] byteCount) throws IOException {
        if (byteCount == null || byteCount.length == 0) {
            byteCount = new int[1];
        }
        TransactionSignature.serialize(this, dos, byteCount);
        return byteCount[0];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TransactionSignature)) {
            return false;
        }
        TransactionSignature signature = (TransactionSignature)obj;
        return this.messageOffset == signature.messageOffset && this.messageLength == signature.messageLength && this.publicKeyOffset == signature.publicKeyOffset && this.publicKeyLength == signature.publicKeyLength && this.signatureOffset == signature.signatureOffset && this.signatureLength == signature.signatureLength && Arrays.equals(this.contents, signature.contents) && this.signatureType == signature.signatureType;
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.messageOffset, this.messageLength, this.publicKeyOffset, this.publicKeyLength, this.signatureOffset, this.signatureLength, this.signatureType});
        result = 31 * result + Arrays.hashCode(this.contents);
        return result;
    }

    @Override
    public int compareTo(TransactionSignature that) {
        if (this == that) {
            return 0;
        }
        if (that == null) {
            throw new NullPointerException();
        }
        int result = Arrays.compare(this.contents, that.contents);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.messageOffset, that.messageOffset);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.messageLength, that.messageLength);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.publicKeyOffset, that.publicKeyOffset);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.publicKeyLength, that.publicKeyLength);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.signatureOffset, that.signatureOffset);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.signatureLength, that.signatureLength);
        if (result != 0) {
            return result;
        }
        return this.signatureType.compareTo(that.signatureType);
    }

    public String toString() {
        return "TransactionSignature{contents=" + Arrays.toString(this.contents) + ", expandedPublicKey=" + Arrays.toString(this.expandedPublicKey) + ", messageOffset=" + this.messageOffset + ", messageLength=" + this.messageLength + ", publicKeyOffset=" + this.publicKeyOffset + ", publicKeyLength=" + this.publicKeyLength + ", signatureOffset=" + this.signatureOffset + ", signatureLength=" + this.signatureLength + ", signatureType=" + this.signatureType + ", signatureStatus=" + this.signatureStatus + ", future=" + this.future + "}";
    }
}

