/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto.engine;

import com.goterl.lazysodium.interfaces.Sign;
import com.swirlds.common.crypto.SignatureType;
import com.swirlds.common.crypto.TransactionSignature;
import com.swirlds.common.crypto.engine.EcdsaSecp256k1VerificationProvider;
import com.swirlds.common.crypto.engine.EcdsaSecp256k1Verifier;
import com.swirlds.common.crypto.engine.Ed25519VerificationProvider;
import com.swirlds.common.crypto.engine.OperationProvider;
import java.security.NoSuchAlgorithmException;

public class DelegatingVerificationProvider
extends OperationProvider<TransactionSignature, Void, Boolean, Object, SignatureType> {
    private final Ed25519VerificationProvider ed25519VerificationProvider;
    private final EcdsaSecp256k1VerificationProvider ecdsaSecp256k1VerificationProvider;

    public DelegatingVerificationProvider(Ed25519VerificationProvider ed25519VerificationProvider, EcdsaSecp256k1VerificationProvider ecdsaSecp256k1VerificationProvider) {
        this.ed25519VerificationProvider = ed25519VerificationProvider;
        this.ecdsaSecp256k1VerificationProvider = ecdsaSecp256k1VerificationProvider;
    }

    @Override
    protected Object loadAlgorithm(SignatureType algorithmType) throws NoSuchAlgorithmException {
        switch (algorithmType) {
            case ECDSA_SECP256K1: {
                return this.ecdsaSecp256k1VerificationProvider.loadAlgorithm(algorithmType);
            }
            case ED25519: {
                return this.ed25519VerificationProvider.loadAlgorithm(algorithmType);
            }
        }
        throw new NoSuchAlgorithmException();
    }

    @Override
    protected Boolean handleItem(Object algorithm, SignatureType algorithmType, TransactionSignature item, Void unused) throws NoSuchAlgorithmException {
        switch (algorithmType) {
            case ECDSA_SECP256K1: {
                EcdsaSecp256k1Verifier ecdsaSecp256k1Algo = (EcdsaSecp256k1Verifier)algorithm;
                return this.ecdsaSecp256k1VerificationProvider.handleItem(ecdsaSecp256k1Algo, algorithmType, item, unused);
            }
            case ED25519: {
                Sign.Native ed25519Algo = (Sign.Native)algorithm;
                return this.ed25519VerificationProvider.handleItem(ed25519Algo, algorithmType, item, unused);
            }
        }
        throw new NoSuchAlgorithmException();
    }
}

