/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto.engine;

import com.goterl.lazysodium.LazySodiumJava;
import com.goterl.lazysodium.SodiumJava;
import com.goterl.lazysodium.interfaces.Sign;
import com.swirlds.common.crypto.SignatureType;
import com.swirlds.common.crypto.TransactionSignature;
import com.swirlds.common.crypto.engine.OperationProvider;
import com.swirlds.common.utility.CommonUtils;
import com.swirlds.logging.LogMarker;
import java.nio.ByteBuffer;

public class Ed25519VerificationProvider
extends OperationProvider<TransactionSignature, Void, Boolean, Sign.Native, SignatureType> {
    private static final Sign.Native algorithm;

    @Override
    protected boolean compute(byte[] message, byte[] signature, byte[] publicKey) {
        return this.compute(message, signature, publicKey, SignatureType.ED25519);
    }

    protected boolean compute(byte[] message, byte[] signature, byte[] publicKey, SignatureType algorithmType) {
        Sign.Native loadedAlgorithm = this.loadAlgorithm(algorithmType);
        return this.compute(loadedAlgorithm, algorithmType, message, signature, publicKey);
    }

    @Override
    protected Sign.Native loadAlgorithm(SignatureType algorithmType) {
        return algorithm;
    }

    @Override
    protected Boolean handleItem(Sign.Native algorithm, SignatureType algorithmType, TransactionSignature item, Void optionalData) {
        return this.compute(algorithm, algorithmType, item);
    }

    private boolean compute(Sign.Native algorithm, SignatureType algorithmType, byte[] message, byte[] signature, byte[] publicKey) {
        boolean isValid = algorithm.cryptoSignVerifyDetached(signature, message, message.length, publicKey);
        if (!isValid && Ed25519VerificationProvider.log().isDebugEnabled()) {
            Ed25519VerificationProvider.log().debug(LogMarker.TESTING_EXCEPTIONS.getMarker(), "Adv Crypto Subsystem: Signature Verification Failure for signature type {} [ publicKey = {}, signature = {} ]", (Object)algorithmType, (Object)CommonUtils.hex(publicKey), (Object)CommonUtils.hex(signature));
        }
        return isValid;
    }

    @Override
    private boolean compute(Sign.Native algorithm, SignatureType algorithmType, TransactionSignature sig) {
        byte[] payload = sig.getContentsDirect();
        byte[] expandedPublicKey = sig.getExpandedPublicKey();
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        ByteBuffer pkBuffer = expandedPublicKey != null && expandedPublicKey.length > 0 ? ByteBuffer.wrap(expandedPublicKey) : buffer;
        byte[] signature = new byte[sig.getSignatureLength()];
        byte[] publicKey = new byte[sig.getPublicKeyLength()];
        byte[] message = new byte[sig.getMessageLength()];
        buffer.position(sig.getMessageOffset()).get(message).position(sig.getSignatureOffset()).get(signature);
        pkBuffer.position(sig.getPublicKeyOffset()).get(publicKey);
        return this.compute(algorithm, algorithmType, message, signature, publicKey);
    }

    static {
        SodiumJava sodiumJava = new SodiumJava();
        algorithm = new LazySodiumJava(sodiumJava);
    }
}

