/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto.engine;

import com.swirlds.common.crypto.engine.AsyncOperationHandler;
import com.swirlds.common.crypto.engine.OperationProvider;
import com.swirlds.common.threading.framework.config.ThreadConfiguration;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.logging.LogMarker;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IntakeDispatcher<Element, Provider extends OperationProvider, Handler extends AsyncOperationHandler> {
    private static final Logger logger = LogManager.getLogger(IntakeDispatcher.class);
    private final Thread worker;
    private final BlockingQueue<List<Element>> backingQueue;
    private final Provider provider;
    private final BiFunction<Provider, List<Element>, Handler> handlerSupplier;
    private final ExecutorService executorService;
    private volatile boolean running = true;

    public IntakeDispatcher(ThreadManager threadManager, Class<Element> elementType, BlockingQueue<List<Element>> backingQueue, Provider provider, int parallelism, BiFunction<Provider, List<Element>, Handler> handlerSupplier) {
        this.backingQueue = backingQueue;
        this.provider = provider;
        this.handlerSupplier = handlerSupplier;
        ThreadFactory threadFactory = ((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(threadManager).setDaemon(true)).setPriority(5)).setComponent("adv crypto")).setThreadName(String.format("%s tp worker", elementType.getSimpleName()))).setExceptionHandler(this::handleThreadException)).buildFactory();
        this.executorService = Executors.newFixedThreadPool(parallelism, threadFactory);
        this.worker = ((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(threadManager).setDaemon(true)).setPriority(5)).setComponent("adv crypto")).setThreadName(String.format("%s intake dispatcher", elementType.getSimpleName()))).setExceptionHandler(this::handleThreadException)).setRunnable(this::execute).build();
        this.worker.start();
    }

    public void shutdown() {
        this.running = false;
        this.worker.interrupt();
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private void execute() {
        while (this.running) {
            try {
                List<Element> workItems = this.backingQueue.take();
                if (workItems.isEmpty()) continue;
                this.executorService.submit((Runnable)this.handlerSupplier.apply(this.provider, workItems));
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void handleThreadException(Thread thread, Throwable ex) {
        logger.error(LogMarker.EXCEPTION.getMarker(), String.format("Intercepted Uncaught Exception [ threadName = '%s' ]", thread.getName()), ex);
    }
}

