/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto.engine;

import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class OperationProvider<Element, OptionalData, Result, Alg, AlgType extends Enum<AlgType>> {
    private static final Logger logger = LogManager.getLogger(OperationProvider.class);

    protected static Logger log() {
        return logger;
    }

    public Result compute(Element item, OptionalData optionalData, AlgType algorithmType) throws NoSuchAlgorithmException {
        return this.handleItem(this.loadAlgorithm(algorithmType), algorithmType, item, optionalData);
    }

    public Result compute(Element item, AlgType algorithmType) throws NoSuchAlgorithmException {
        return this.compute(item, null, algorithmType);
    }

    protected abstract Alg loadAlgorithm(AlgType var1) throws NoSuchAlgorithmException;

    protected abstract Result handleItem(Alg var1, AlgType var2, Element var3, OptionalData var4) throws NoSuchAlgorithmException;
}

