/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto.engine;

import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.HashBuilder;
import com.swirlds.common.crypto.engine.CachingOperationProvider;
import com.swirlds.logging.LogMarker;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class RunningHashProvider
extends CachingOperationProvider<Hash, Hash, Hash, HashBuilder, DigestType> {
    private static final String NEW_HASH_NULL = "RunningHashProvider :: newHashToAdd is null";

    private static void updateForHash(HashBuilder hashBuilder, Hash hash) {
        hashBuilder.update(hash.getClassId());
        hashBuilder.update(hash.getVersion());
        hashBuilder.update(hash);
    }

    @Override
    protected HashBuilder handleAlgorithmRequired(DigestType algorithmType) throws NoSuchAlgorithmException {
        return new HashBuilder(MessageDigest.getInstance(algorithmType.algorithmName()));
    }

    @Override
    protected Hash handleItem(HashBuilder hashBuilder, DigestType algorithmType, Hash runningHash, Hash newHashToAdd) {
        if (newHashToAdd == null) {
            RunningHashProvider.log().trace(LogMarker.TESTING_EXCEPTIONS.getMarker(), NEW_HASH_NULL);
            throw new IllegalArgumentException(NEW_HASH_NULL);
        }
        hashBuilder.reset();
        if (runningHash != null) {
            RunningHashProvider.updateForHash(hashBuilder, runningHash);
        }
        RunningHashProvider.updateForHash(hashBuilder, newHashToAdd);
        return hashBuilder.build();
    }

    @Override
    public Hash compute(Hash runningHash, Hash newHashToAdd, DigestType algorithmType) throws NoSuchAlgorithmException {
        return this.handleItem((HashBuilder)this.loadAlgorithm(algorithmType), algorithmType, runningHash, newHashToAdd);
    }
}

