/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.copy;

import com.swirlds.common.constructable.ConstructableRegistry;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.copy.MerkleInitialize;
import com.swirlds.common.merkle.copy.NodeToCopy;
import com.swirlds.common.merkle.exceptions.MerkleCopyException;
import com.swirlds.common.merkle.route.MerkleRoute;
import java.util.LinkedList;
import java.util.Queue;

public final class MerkleCopy {
    private MerkleCopy() {
    }

    public static MerkleNode copyAnyNodeType(MerkleNode node) {
        if (node == null) {
            return null;
        }
        if (node.isLeaf()) {
            return node.copy();
        }
        MerkleNode copy = (MerkleNode)ConstructableRegistry.getInstance().createObject(node.getClassId());
        if (copy == null) {
            throw new MerkleCopyException(String.format("Unable to construct object with class ID %d(0x%08X): %s", node.getClassId(), node.getClassId(), node.getClass().getName()));
        }
        return copy;
    }

    private static void addChildrenToQueue(NodeToCopy parentNodeCopyInfo, MerkleNode oldParent, MerkleNode copiedParent, Queue<NodeToCopy> queue) {
        if (oldParent == null || oldParent.isLeaf()) {
            return;
        }
        MerkleInternal internal = (MerkleInternal)oldParent.cast();
        for (int childIndex = 0; childIndex < internal.getNumberOfChildren(); ++childIndex) {
            queue.add(new NodeToCopy(copiedParent.asInternal(), childIndex, (MerkleNode)internal.getChild(childIndex), parentNodeCopyInfo.getOriginalNodeInSamePositionOfChild(childIndex)));
        }
    }

    public static <T extends MerkleNode> T copyTreeToLocation(MerkleInternal parent, int index, T child) {
        if (child != null) {
            child.reserve();
        }
        LinkedList<NodeToCopy> nodesToCopy = new LinkedList<NodeToCopy>();
        MerkleNode rootOfSubtree = null;
        MerkleNode originalNodeInSubtreeRootPosition = null;
        if (parent.getNumberOfChildren() > index) {
            originalNodeInSubtreeRootPosition = (MerkleNode)parent.getChild(index);
        }
        nodesToCopy.add(new NodeToCopy(parent, index, child, originalNodeInSubtreeRootPosition));
        while (!nodesToCopy.isEmpty()) {
            NodeToCopy nodeToCopy = (NodeToCopy)nodesToCopy.remove();
            MerkleNode original = nodeToCopy.getNodeToCopy();
            MerkleNode copy = MerkleCopy.copyAnyNodeType(original);
            MerkleCopy.addChildrenToQueue(nodeToCopy, original, copy, nodesToCopy);
            if (rootOfSubtree == null) {
                rootOfSubtree = copy;
            }
            nodeToCopy.getNewParent().setChild(nodeToCopy.getIndexInParent(), copy, nodeToCopy.getRouteForNode(), false);
        }
        if (rootOfSubtree != null) {
            MerkleInitialize.initializeTreeAfterCopy(rootOfSubtree);
        }
        if (child != null) {
            child.release();
        }
        return (T)rootOfSubtree;
    }

    public static void adoptChildren(MerkleInternal originalParent, MerkleInternal newParent) {
        for (int childIndex = 0; childIndex < originalParent.getNumberOfChildren(); ++childIndex) {
            Object child = originalParent.getChild(childIndex);
            MerkleRoute childRoute = null;
            if (child != null) {
                childRoute = child.getRoute();
            }
            newParent.setChild(childIndex, (MerkleNode)child, childRoute, true);
        }
    }
}

