/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.copy;

import com.swirlds.common.io.ExternalSelfSerializable;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public final class MerkleInitialize {
    private MerkleInitialize() {
    }

    public static MerkleNode initializeAndMigrateTreeAfterDeserialization(MerkleNode root, Map<Long, Integer> deserializationVersions) {
        if (root == null) {
            return null;
        }
        Predicate<MerkleNode> filter = node -> !(node instanceof ExternalSelfSerializable);
        Predicate<MerkleInternal> descendantFilter = filter::test;
        root.treeIterator().setFilter(filter).setDescendantFilter(descendantFilter).forEachRemaining(node -> {
            MerkleInternal internal = node.asInternal();
            for (int childIndex = 0; childIndex < internal.getNumberOfChildren(); ++childIndex) {
                int deserializationVersion;
                MerkleNode migratedChild;
                Object child = internal.getChild(childIndex);
                if (child == null || (migratedChild = child.migrate(deserializationVersion = Objects.requireNonNull((Integer)deserializationVersions.get(child.getClassId()), "class not discovered during deserialization").intValue())) == child) continue;
                internal.setChild(childIndex, migratedChild);
            }
            node.asInternal().rebuild();
        });
        int deserializationVersion = Objects.requireNonNull(deserializationVersions.get(root.getClassId()), "class not discovered during deserialization");
        return root.migrate(deserializationVersion);
    }

    public static void initializeTreeAfterCopy(MerkleNode root) {
        if (root == null) {
            return;
        }
        Predicate<MerkleNode> filter = node -> !node.isLeaf();
        root.treeIterator().setFilter(filter).forEachRemaining(node -> ((MerkleInternal)node).rebuild());
    }
}

