/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.copy;

import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.copy.MerkleCopy;
import com.swirlds.common.merkle.exceptions.MerkleRouteException;
import com.swirlds.common.merkle.route.MerkleRoute;
import java.util.Iterator;

public final class MerklePathReplacement {
    private static final int CHILD_PATH_OFFSET = -1;
    private static final int PARENT_PATH_OFFSET = -2;
    private static final int GRANDPARENT_PATH_OFFSET = -3;

    private MerklePathReplacement() {
    }

    private static MerkleNode copyChildIfNeeded(MerkleNode child, int pathIndex, int pathLength, int skipAtEnd, int artificialChildReferences, MerkleInternal parentInPath, int indexToCopy, boolean previousNodeCopied) {
        if (pathIndex >= pathLength - skipAtEnd) {
            return child;
        }
        MerkleNode childInPath = child;
        if (previousNodeCopied || child.getReservationCount() > 1 + artificialChildReferences) {
            childInPath = MerkleCopy.copyAnyNodeType(child);
            parentInPath.setChild(indexToCopy, childInPath, child.getRoute(), false);
            if (child.isInternal()) {
                MerkleCopy.adoptChildren(child.asInternal(), childInPath.asInternal());
            }
        } else {
            childInPath.invalidateHash();
        }
        return childInPath;
    }

    private static void skipStepsInRoute(Iterator<Integer> iterator, int stepsToSkip) {
        for (int i = 0; i < stepsToSkip; ++i) {
            if (!iterator.hasNext()) {
                throw new IllegalStateException("can not skip more steps there exist within the iterator");
            }
            iterator.next();
        }
    }

    private static void addNodeToPath(MerkleNode[] path, boolean[] nodesRequiringInitialization, int pathIndex, MerkleNode node, boolean nodeWasCopied) {
        path[pathIndex] = node;
        nodesRequiringInitialization[pathIndex] = nodeWasCopied;
    }

    private static int handleArtificialReferences(boolean isLastNode, MerkleNode root, MerkleNode parent, MerkleNode child) {
        int artificialChildReferences = 0;
        if (!isLastNode) {
            child.reserve();
            ++artificialChildReferences;
        }
        if (parent != root) {
            parent.release();
        }
        return artificialChildReferences;
    }

    private static void initializePath(MerkleNode[] path, boolean[] nodeRequiringInitialization) {
        for (int index = path.length - 1; index >= 0; --index) {
            MerkleNode node;
            if (!nodeRequiringInitialization[index] || (node = path[index]).isLeaf()) continue;
            node.asInternal().rebuild();
        }
    }

    public static MerkleNode[] replacePath(MerkleNode root, MerkleRoute route) {
        return MerklePathReplacement.replacePath(root, route, 0);
    }

    public static MerkleNode[] replacePath(MerkleNode firstNodeInPath, MerkleRoute route, int skipAtEnd) {
        MerkleInternal parent;
        if (firstNodeInPath == null) {
            throw new IllegalArgumentException("Can not replace path in null tree");
        }
        int firstNodeDepth = firstNodeInPath.getRoute().size();
        int pathLength = route.size() - firstNodeDepth + 1;
        Iterator<Integer> iterator = route.iterator();
        MerklePathReplacement.skipStepsInRoute(iterator, firstNodeDepth);
        MerkleNode[] path = new MerkleNode[pathLength];
        boolean[] nodesRequiringInitialization = new boolean[pathLength];
        int pathIndex = 0;
        MerklePathReplacement.addNodeToPath(path, nodesRequiringInitialization, pathIndex, firstNodeInPath, false);
        ++pathIndex;
        if (firstNodeInPath.isLeaf()) {
            if (pathLength != 1) {
                throw new MerkleRouteException("First node is a leaf but path has length " + pathLength);
            }
            return path;
        }
        MerkleInternal parentInPath = parent = (MerkleInternal)firstNodeInPath.cast();
        boolean previousNodeCopied = false;
        while (iterator.hasNext()) {
            int indexToCopy = iterator.next();
            Object child = parent.getChild(indexToCopy);
            int artificialChildReferences = MerklePathReplacement.handleArtificialReferences(!iterator.hasNext(), firstNodeInPath, parent, child);
            MerkleNode childInPath = MerklePathReplacement.copyChildIfNeeded(child, pathIndex, pathLength, skipAtEnd, artificialChildReferences, parentInPath, indexToCopy, previousNodeCopied);
            boolean nodeWasCopied = child != childInPath;
            previousNodeCopied |= nodeWasCopied;
            MerklePathReplacement.addNodeToPath(path, nodesRequiringInitialization, pathIndex, childInPath, nodeWasCopied);
            ++pathIndex;
            if (!iterator.hasNext()) continue;
            parent = (MerkleInternal)child.cast();
            parentInPath = (MerkleInternal)childInPath.cast();
        }
        MerklePathReplacement.initializePath(path, nodesRequiringInitialization);
        if (pathIndex != pathLength) {
            throw new MerkleRouteException("Path expected to be of length " + pathLength + " but is actually of length " + pathIndex);
        }
        return path;
    }

    public static <T extends MerkleNode> T getChildInPath(MerkleNode[] path) {
        return path[path.length + -1].cast();
    }

    public static <T extends MerkleInternal> T getParentInPath(MerkleNode[] path) {
        return (T)((MerkleInternal)path[path.length + -2].cast());
    }

    public static <T extends MerkleInternal> T getGrandparentInPath(MerkleNode[] path) {
        return (T)((MerkleInternal)path[path.length + -3].cast());
    }
}

