/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.crypto.internal;

import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.HashBuilder;
import com.swirlds.common.crypto.engine.CachingOperationProvider;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.exceptions.IllegalChildHashException;
import com.swirlds.logging.LogMarker;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;

public class MerkleInternalDigestProvider
extends CachingOperationProvider<MerkleInternal, List<Hash>, Hash, HashBuilder, DigestType> {
    @Override
    protected HashBuilder handleAlgorithmRequired(DigestType algorithmType) throws NoSuchAlgorithmException {
        return new HashBuilder(MessageDigest.getInstance(algorithmType.algorithmName()));
    }

    @Override
    protected Hash handleItem(HashBuilder hashBuilder, DigestType algorithmType, MerkleInternal node, List<Hash> childHashes) {
        hashBuilder.reset();
        hashBuilder.update(node.getClassId());
        hashBuilder.update(node.getVersion());
        for (int index = 0; index < childHashes.size(); ++index) {
            Hash childHash = childHashes.get(index);
            if (childHash == null) {
                Object childNode = node.getChild(index);
                String msg = String.format("Child has an unexpected null hash [ parentClass = '%s', childClass = '%s', childRoute = %s ]", node.getClass().getName(), childNode.getClass().getName(), childNode.getRoute());
                MerkleInternalDigestProvider.log().trace(LogMarker.TESTING_EXCEPTIONS.getMarker(), msg);
                throw new IllegalChildHashException(msg);
            }
            hashBuilder.update(childHash);
        }
        return hashBuilder.build();
    }

    @Override
    public Hash compute(MerkleInternal node, List<Hash> childHashes, DigestType algorithmType) throws NoSuchAlgorithmException {
        return this.handleItem((HashBuilder)this.loadAlgorithm(algorithmType), algorithmType, node, childHashes);
    }
}

