/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.impl.internal;

import com.swirlds.common.Mutable;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.Hashable;
import com.swirlds.common.merkle.exceptions.MerkleRouteException;
import com.swirlds.common.merkle.interfaces.HasMerkleRoute;
import com.swirlds.common.merkle.interfaces.MerkleType;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.merkle.route.MerkleRouteFactory;
import com.swirlds.common.utility.AbstractReservable;
import java.beans.Transient;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractMerkleNode
extends AbstractReservable
implements Hashable,
HasMerkleRoute,
Mutable,
MerkleType {
    private boolean immutable;
    private MerkleRoute route;
    private Hash hash = null;

    protected AbstractMerkleNode() {
        this.immutable = false;
        this.route = MerkleRouteFactory.getEmptyRoute();
    }

    protected AbstractMerkleNode(AbstractMerkleNode that) {
        this.route = that.getRoute();
    }

    @Override
    public Hash getHash() {
        return this.hash;
    }

    @Override
    public void setHash(Hash hash) {
        this.hash = hash;
    }

    @Override
    public boolean isImmutable() {
        return this.immutable;
    }

    @Transient
    public void setImmutable(boolean immutable) {
        this.immutable = immutable;
    }

    @Override
    public MerkleRoute getRoute() {
        return this.route;
    }

    @Override
    public void setRoute(MerkleRoute route) {
        if (this.getRoute() != route && !this.getRoute().equals(route) && this.getReservationCount() > 1) {
            throw new MerkleRouteException("Routes can not be set unless the reservation count is 0 or 1. (type = " + this.getClass().getName() + ", reservation count = " + this.getReservationCount() + ")");
        }
        this.route = route;
    }

    protected void destroyNode() {
    }

    @Override
    protected void onDestroy() {
        this.destroyNode();
    }
}

