/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.iterators.internal;

import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.iterators.internal.MerkleIterationAlgorithm;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ObjIntConsumer;

public class PostOrderedDepthFirstAlgorithm
implements MerkleIterationAlgorithm {
    private static final int INITIAL_STACK_CAPACITY = 1024;
    private final List<MerkleNode> stack = new ArrayList<MerkleNode>(1024);

    @Override
    public void push(MerkleNode node) {
        this.stack.add(node);
    }

    @Override
    public MerkleNode pop() {
        return this.stack.remove(this.stack.size() - 1);
    }

    @Override
    public MerkleNode peek() {
        return this.stack.get(this.stack.size() - 1);
    }

    @Override
    public int size() {
        return this.stack.size();
    }

    @Override
    public void pushChildren(MerkleInternal parent, ObjIntConsumer<MerkleInternal> pushNode) {
        for (int childIndex = parent.getNumberOfChildren() - 1; childIndex >= 0; --childIndex) {
            pushNode.accept(parent, childIndex);
        }
    }
}

