/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.MetricsFactory;
import com.swirlds.common.utility.CommonUtils;
import java.util.EnumSet;
import java.util.function.DoubleBinaryOperator;
import org.apache.commons.lang3.builder.ToStringBuilder;

public interface DoubleAccumulator
extends Metric {
    @Override
    default public Metric.DataType getDataType() {
        return Metric.DataType.FLOAT;
    }

    @Override
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE);
    }

    @Override
    default public Double get(Metric.ValueType valueType) {
        CommonUtils.throwArgNull(valueType, "valueType");
        if (valueType == Metric.ValueType.VALUE) {
            return this.get();
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + valueType);
    }

    public double get();

    public double getInitialValue();

    public void update(double var1);

    public static final class Config
    extends MetricConfig<DoubleAccumulator, Config> {
        private final DoubleBinaryOperator accumulator;
        private final double initialValue;

        public Config(String category, String name) {
            super(category, name, "%,11.3f");
            this.accumulator = Double::max;
            this.initialValue = 0.0;
        }

        private Config(String category, String name, String description, String unit, String format, DoubleBinaryOperator accumulator, double initialValue) {
            super(category, name, description, unit, format);
            this.accumulator = CommonUtils.throwArgNull(accumulator, "accumulator");
            this.initialValue = initialValue;
        }

        @Override
        public Config withDescription(String description) {
            return new Config(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat(), this.getAccumulator(), this.getInitialValue());
        }

        @Override
        public Config withUnit(String unit) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat(), this.getAccumulator(), this.getInitialValue());
        }

        public Config withFormat(String format) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format, this.getAccumulator(), this.getInitialValue());
        }

        public DoubleBinaryOperator getAccumulator() {
            return this.accumulator;
        }

        public Config withAccumulator(DoubleBinaryOperator accumulator) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), accumulator, this.getInitialValue());
        }

        public double getInitialValue() {
            return this.initialValue;
        }

        public Config withInitialValue(double initialValue) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getAccumulator(), initialValue);
        }

        @Override
        public Class<DoubleAccumulator> getResultClass() {
            return DoubleAccumulator.class;
        }

        @Override
        DoubleAccumulator create(MetricsFactory factory) {
            return factory.createDoubleAccumulator(this);
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("initialValue", this.initialValue).toString();
        }
    }
}

