/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.MetricsFactory;
import com.swirlds.common.utility.CommonUtils;
import java.util.EnumSet;
import java.util.function.Supplier;
import org.apache.commons.lang3.builder.ToStringBuilder;

public interface FunctionGauge<T>
extends Metric {
    @Override
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE);
    }

    default public T get(Metric.ValueType valueType) {
        CommonUtils.throwArgNull(valueType, "valueType");
        if (valueType == Metric.ValueType.VALUE) {
            return this.get();
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + valueType);
    }

    public T get();

    public static final class Config<T>
    extends MetricConfig<FunctionGauge<T>, Config<T>> {
        private final Class<T> type;
        private final Supplier<T> supplier;

        public Config(String category, String name, Class<T> type, Supplier<T> supplier) {
            super(category, name, "%s");
            this.type = CommonUtils.throwArgNull(type, "type");
            this.supplier = CommonUtils.throwArgNull(supplier, "supplier");
        }

        private Config(String category, String name, String description, String unit, String format, Class<T> type, Supplier<T> supplier) {
            super(category, name, description, unit, format);
            this.type = CommonUtils.throwArgNull(type, "type");
            this.supplier = CommonUtils.throwArgNull(supplier, "supplier");
        }

        @Override
        public Config<T> withDescription(String description) {
            return new Config<T>(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat(), this.getType(), this.getSupplier());
        }

        @Override
        public Config<T> withUnit(String unit) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat(), this.getType(), this.getSupplier());
        }

        public Config<T> withFormat(String format) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format, this.getType(), this.getSupplier());
        }

        public Class<T> getType() {
            return this.type;
        }

        public Supplier<T> getSupplier() {
            return this.supplier;
        }

        @Override
        public Class<FunctionGauge<T>> getResultClass() {
            return FunctionGauge.class;
        }

        @Override
        FunctionGauge<T> create(MetricsFactory factory) {
            return factory.createFunctionGauge(this);
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("type", (Object)this.type.getName()).toString();
        }
    }
}

