/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.MetricsFactory;
import com.swirlds.common.utility.CommonUtils;
import java.util.EnumSet;
import java.util.function.BiFunction;
import java.util.function.IntBinaryOperator;
import org.apache.commons.lang3.builder.ToStringBuilder;

public interface IntegerPairAccumulator<T>
extends Metric {
    public static final BiFunction<Integer, Integer, Double> AVERAGE = (sum, count) -> {
        if (count == 0) {
            return 0.0;
        }
        return (double)sum.intValue() / (double)count.intValue();
    };

    @Override
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE);
    }

    default public T get(Metric.ValueType valueType) {
        CommonUtils.throwArgNull(valueType, "valueType");
        if (valueType == Metric.ValueType.VALUE) {
            return this.get();
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + valueType);
    }

    public T get();

    public int getLeft();

    public int getRight();

    public void update(int var1, int var2);

    public static final class Config<T>
    extends MetricConfig<IntegerPairAccumulator<T>, Config<T>> {
        private final Class<T> type;
        private final BiFunction<Integer, Integer, T> resultFunction;
        private final IntBinaryOperator leftAccumulator;
        private final IntBinaryOperator rightAccumulator;

        public Config(String category, String name, Class<T> type, BiFunction<Integer, Integer, T> resultFunction) {
            super(category, name, "%s");
            this.type = CommonUtils.throwArgNull(type, "type");
            this.resultFunction = CommonUtils.throwArgNull(resultFunction, "resultFunction");
            this.leftAccumulator = Integer::sum;
            this.rightAccumulator = Integer::sum;
        }

        private Config(String category, String name, String description, String unit, String format, Class<T> type, BiFunction<Integer, Integer, T> resultFunction, IntBinaryOperator leftAccumulator, IntBinaryOperator rightAccumulator) {
            super(category, name, description, unit, format);
            this.type = CommonUtils.throwArgNull(type, "type");
            this.resultFunction = CommonUtils.throwArgNull(resultFunction, "resultFunction");
            this.leftAccumulator = CommonUtils.throwArgNull(leftAccumulator, "leftAccumulator");
            this.rightAccumulator = CommonUtils.throwArgNull(rightAccumulator, "rightAccumulator");
        }

        @Override
        public Config<T> withDescription(String description) {
            return new Config<T>(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat(), this.getType(), this.getResultFunction(), this.getLeftAccumulator(), this.getRightAccumulator());
        }

        @Override
        public Config<T> withUnit(String unit) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat(), this.getType(), this.getResultFunction(), this.getLeftAccumulator(), this.getRightAccumulator());
        }

        public Config<T> withFormat(String format) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format, this.getType(), this.getResultFunction(), this.getLeftAccumulator(), this.getRightAccumulator());
        }

        public Class<T> getType() {
            return this.type;
        }

        public IntBinaryOperator getLeftAccumulator() {
            return this.leftAccumulator;
        }

        public Config<T> withLeftAccumulator(IntBinaryOperator leftAccumulator) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getResultFunction(), leftAccumulator, this.getRightAccumulator());
        }

        public IntBinaryOperator getRightAccumulator() {
            return this.rightAccumulator;
        }

        public Config<T> withRightAccumulator(IntBinaryOperator rightAccumulator) {
            return new Config<T>(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getType(), this.getResultFunction(), this.getLeftAccumulator(), rightAccumulator);
        }

        public BiFunction<Integer, Integer, T> getResultFunction() {
            return this.resultFunction;
        }

        @Override
        public Class<IntegerPairAccumulator<T>> getResultClass() {
            return IntegerPairAccumulator.class;
        }

        @Override
        IntegerPairAccumulator<T> create(MetricsFactory factory) {
            return factory.createIntegerPairAccumulator(this);
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("type", (Object)this.type.getName()).toString();
        }
    }
}

