/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.MetricsFactory;
import com.swirlds.common.utility.CommonUtils;
import java.util.EnumSet;
import java.util.function.LongBinaryOperator;
import org.apache.commons.lang3.builder.ToStringBuilder;

public interface LongAccumulator
extends Metric {
    @Override
    default public Metric.DataType getDataType() {
        return Metric.DataType.INT;
    }

    @Override
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE);
    }

    @Override
    default public Long get(Metric.ValueType valueType) {
        CommonUtils.throwArgNull(valueType, "valueType");
        if (valueType == Metric.ValueType.VALUE) {
            return this.get();
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + valueType);
    }

    public long get();

    public long getInitialValue();

    public void update(long var1);

    public static final class Config
    extends MetricConfig<LongAccumulator, Config> {
        private final LongBinaryOperator accumulator;
        private final long initialValue;

        public Config(String category, String name) {
            super(category, name, "%d");
            this.accumulator = Long::max;
            this.initialValue = 0L;
        }

        private Config(String category, String name, String description, String unit, String format, LongBinaryOperator accumulator, long initialValue) {
            super(category, name, description, unit, format);
            this.accumulator = CommonUtils.throwArgNull(accumulator, "accumulator");
            this.initialValue = initialValue;
        }

        @Override
        public Config withDescription(String description) {
            return new Config(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat(), this.getAccumulator(), this.getInitialValue());
        }

        @Override
        public Config withUnit(String unit) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat(), this.getAccumulator(), this.getInitialValue());
        }

        public Config withFormat(String format) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format, this.getAccumulator(), this.getInitialValue());
        }

        public LongBinaryOperator getAccumulator() {
            return this.accumulator;
        }

        public Config withAccumulator(LongBinaryOperator accumulator) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), accumulator, this.getInitialValue());
        }

        public long getInitialValue() {
            return this.initialValue;
        }

        public Config withInitialValue(long initialValue) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getAccumulator(), initialValue);
        }

        @Override
        public Class<LongAccumulator> getResultClass() {
            return LongAccumulator.class;
        }

        @Override
        LongAccumulator create(MetricsFactory factory) {
            return factory.createLongAccumulator(this);
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("initialValue", this.initialValue).toString();
        }
    }
}

