/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.atomic;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class AtomicDouble {
    private volatile long bits;
    private static final AtomicLongFieldUpdater<AtomicDouble> updater = AtomicLongFieldUpdater.newUpdater(AtomicDouble.class, "bits");

    public AtomicDouble(double initialValue) {
        this.bits = Double.doubleToRawLongBits(initialValue);
    }

    public AtomicDouble() {
    }

    public final double get() {
        return Double.longBitsToDouble(this.bits);
    }

    public final void set(double newValue) {
        this.bits = Double.doubleToRawLongBits(newValue);
    }

    public final double getAndSet(double newValue) {
        long newBits = Double.doubleToRawLongBits(newValue);
        return Double.longBitsToDouble(updater.getAndSet(this, newBits));
    }

    public final boolean compareAndSet(double expectedValue, double newValue) {
        long expectedBits = Double.doubleToRawLongBits(expectedValue);
        long newBits = Double.doubleToRawLongBits(newValue);
        return updater.compareAndSet(this, expectedBits, newBits);
    }
}

