/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.atomic;

import java.util.concurrent.atomic.LongAccumulator;
import java.util.function.BiFunction;
import java.util.function.IntBinaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.ToDoubleBiFunction;

public class AtomicIntPair {
    public static final int INT_BITS = 32;
    private final LongAccumulator container;

    public AtomicIntPair() {
        this(Integer::sum, Integer::sum);
    }

    public AtomicIntPair(IntBinaryOperator leftAccumulator, IntBinaryOperator rightAccumulator) {
        LongBinaryOperator operator = (current, supplied) -> {
            int left = leftAccumulator.applyAsInt(AtomicIntPair.extractLeft(current), AtomicIntPair.extractLeft(supplied));
            int right = rightAccumulator.applyAsInt(AtomicIntPair.extractRight(current), AtomicIntPair.extractRight(supplied));
            return AtomicIntPair.combine(left, right);
        };
        this.container = new LongAccumulator(operator, 0L);
    }

    public void accumulate(int leftValue, int rightValue) {
        this.container.accumulate(AtomicIntPair.combine(leftValue, rightValue));
    }

    public int getLeft() {
        return AtomicIntPair.extractLeft(this.container.get());
    }

    public int getRight() {
        return AtomicIntPair.extractRight(this.container.get());
    }

    public double computeDouble(ToDoubleBiFunction<Integer, Integer> compute) {
        long twoInts = this.container.get();
        return compute.applyAsDouble(AtomicIntPair.extractLeft(twoInts), AtomicIntPair.extractRight(twoInts));
    }

    public double computeDoubleAndReset(ToDoubleBiFunction<Integer, Integer> compute) {
        long twoInts = this.container.getThenReset();
        return compute.applyAsDouble(AtomicIntPair.extractLeft(twoInts), AtomicIntPair.extractRight(twoInts));
    }

    public <T> T compute(BiFunction<Integer, Integer, T> compute) {
        long twoInts = this.container.get();
        return compute.apply(AtomicIntPair.extractLeft(twoInts), AtomicIntPair.extractRight(twoInts));
    }

    public <T> T computeAndReset(BiFunction<Integer, Integer, T> compute) {
        long twoInts = this.container.getThenReset();
        return compute.apply(AtomicIntPair.extractLeft(twoInts), AtomicIntPair.extractRight(twoInts));
    }

    public void reset() {
        this.container.reset();
    }

    private static int extractLeft(long pair) {
        return (int)(pair >> 32);
    }

    private static int extractRight(long pair) {
        return (int)pair;
    }

    private static long combine(int left, int right) {
        return (long)left << 32 | (long)right & 0xFFFFFFFFL;
    }
}

