/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.common.metrics.Counter;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.platform.DefaultMetric;
import com.swirlds.common.metrics.platform.Snapshot;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class DefaultCounter
extends DefaultMetric
implements Counter {
    private static final String INCREASE_ONLY_ERROR_MESSAGE = "The value of a a Counter can only be increased";
    private final LongAdder adder = new LongAdder();

    public DefaultCounter(Counter.Config config) {
        super(config);
    }

    @Override
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, this.get()));
    }

    @Override
    public long get() {
        return this.adder.sum();
    }

    @Override
    public void add(long value) {
        if (value <= 0L) {
            throw new IllegalArgumentException(INCREASE_ONLY_ERROR_MESSAGE);
        }
        this.adder.add(value);
    }

    @Override
    public void increment() {
        this.adder.increment();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("value", this.adder.sum()).toString();
    }
}

