/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.common.metrics.DoubleAccumulator;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.platform.DefaultMetric;
import com.swirlds.common.metrics.platform.Snapshot;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class DefaultDoubleAccumulator
extends DefaultMetric
implements DoubleAccumulator {
    private final java.util.concurrent.atomic.DoubleAccumulator container;
    private final double initialValue;

    public DefaultDoubleAccumulator(DoubleAccumulator.Config config) {
        super(config);
        this.container = new java.util.concurrent.atomic.DoubleAccumulator(config.getAccumulator(), config.getInitialValue());
        this.initialValue = config.getInitialValue();
    }

    @Override
    public double getInitialValue() {
        return this.initialValue;
    }

    @Override
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, this.container.getThenReset()));
    }

    @Override
    public double get() {
        return this.container.get();
    }

    @Override
    public void update(double other) {
        this.container.accumulate(other);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("initialValue", this.initialValue).append("value", this.get()).toString();
    }
}

