/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.common.metrics.IntegerAccumulator;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.platform.DefaultMetric;
import com.swirlds.common.metrics.platform.Snapshot;
import java.util.List;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.function.IntBinaryOperator;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class DefaultIntegerAccumulator
extends DefaultMetric
implements IntegerAccumulator {
    private final LongAccumulator container;
    private final IntBinaryOperator accumulator;
    private final int initialValue;

    public DefaultIntegerAccumulator(IntegerAccumulator.Config config) {
        super(config);
        this.accumulator = config.getAccumulator();
        this.container = new LongAccumulator((op1, op2) -> this.accumulator.applyAsInt((int)op1, (int)op2), config.getInitialValue());
        this.initialValue = config.getInitialValue();
    }

    @Override
    public int getInitialValue() {
        return this.initialValue;
    }

    @Override
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, (int)this.container.getThenReset()));
    }

    @Override
    public int get() {
        return (int)this.container.get();
    }

    @Override
    public void update(int other) {
        this.container.accumulate(other);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("initialValue", this.initialValue).append("value", this.get()).toString();
    }
}

