/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.common.metrics.IntegerPairAccumulator;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.atomic.AtomicIntPair;
import com.swirlds.common.metrics.platform.DefaultMetric;
import com.swirlds.common.metrics.platform.Snapshot;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class DefaultIntegerPairAccumulator<T>
extends DefaultMetric
implements IntegerPairAccumulator<T> {
    private final Metric.DataType dataType;
    private final AtomicIntPair container;
    private final BiFunction<Integer, Integer, T> resultFunction;

    public DefaultIntegerPairAccumulator(IntegerPairAccumulator.Config<T> config) {
        super(config);
        this.dataType = MetricConfig.mapDataType(config.getType());
        this.container = new AtomicIntPair(config.getLeftAccumulator(), config.getRightAccumulator());
        this.resultFunction = config.getResultFunction();
    }

    @Override
    public Metric.DataType getDataType() {
        return this.dataType;
    }

    @Override
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, this.container.computeAndReset(this.resultFunction)));
    }

    @Override
    public T get() {
        return this.container.compute(this.resultFunction);
    }

    @Override
    public int getLeft() {
        return this.container.getLeft();
    }

    @Override
    public int getRight() {
        return this.container.getRight();
    }

    @Override
    public void update(int leftValue, int rightValue) {
        this.container.accumulate(leftValue, rightValue);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("value", this.get()).toString();
    }
}

