/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.sun.net.httpserver.HttpServer;
import com.swirlds.common.internal.SettingsCommon;
import com.swirlds.common.metrics.Metrics;
import com.swirlds.common.metrics.MetricsFactory;
import com.swirlds.common.metrics.MetricsProvider;
import com.swirlds.common.metrics.platform.DefaultMetrics;
import com.swirlds.common.metrics.platform.DefaultMetricsFactory;
import com.swirlds.common.metrics.platform.LegacyCsvWriter;
import com.swirlds.common.metrics.platform.MetricKeyRegistry;
import com.swirlds.common.metrics.platform.SnapshotService;
import com.swirlds.common.metrics.platform.prometheus.PrometheusEndpoint;
import com.swirlds.common.system.NodeId;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.common.utility.CommonUtils;
import com.swirlds.common.utility.Lifecycle;
import com.swirlds.common.utility.LifecyclePhase;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultMetricsProvider
implements MetricsProvider,
Lifecycle {
    private static final Logger logger = LogManager.getLogger(DefaultMetricsProvider.class);
    private static final String USER_DIR = "user.dir";
    private final MetricsFactory factory = new DefaultMetricsFactory();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(AdHocThreadManager.getStaticThreadManager().createThreadFactory("platform-core", "MetricsThread"));
    private final MetricKeyRegistry metricKeyRegistry = new MetricKeyRegistry();
    private final DefaultMetrics globalMetrics;
    private final ConcurrentMap<NodeId, DefaultMetrics> platformMetrics = new ConcurrentHashMap<NodeId, DefaultMetrics>();
    private final PrometheusEndpoint prometheusEndpoint;
    private final SnapshotService snapshotService;
    private LifecyclePhase lifecyclePhase = LifecyclePhase.NOT_STARTED;

    public DefaultMetricsProvider() {
        Duration interval = Duration.ofMillis(SettingsCommon.csvWriteFrequency);
        this.globalMetrics = new DefaultMetrics(null, this.metricKeyRegistry, this.executor, this.factory);
        this.snapshotService = new SnapshotService(this.globalMetrics, this.executor, interval);
        PrometheusEndpoint endpoint = null;
        if (!SettingsCommon.disableMetricsOutput && SettingsCommon.prometheusEndpointEnabled) {
            InetSocketAddress address = new InetSocketAddress(SettingsCommon.prometheusEndpointPortNumber);
            try {
                HttpServer httpServer = HttpServer.create(address, SettingsCommon.prometheusEndpointMaxBacklogAllowed);
                endpoint = new PrometheusEndpoint(httpServer);
                this.globalMetrics.subscribe(endpoint::handleMetricsChange);
                this.snapshotService.subscribe(endpoint::handleSnapshots);
            }
            catch (IOException e) {
                logger.error("Exception while setting up Prometheus endpoint", (Throwable)e);
            }
        }
        this.prometheusEndpoint = endpoint;
    }

    @Override
    public Metrics createGlobalMetrics() {
        return this.globalMetrics;
    }

    @Override
    public Metrics createPlatformMetrics(NodeId nodeId) {
        CommonUtils.throwArgNull(nodeId, "selfId");
        DefaultMetrics newMetrics = new DefaultMetrics(nodeId, this.metricKeyRegistry, this.executor, this.factory);
        DefaultMetrics oldMetrics = this.platformMetrics.putIfAbsent(nodeId, newMetrics);
        if (oldMetrics != null) {
            throw new IllegalStateException(String.format("PlatformMetrics for %s already exists", nodeId));
        }
        this.globalMetrics.subscribe(newMetrics::handleGlobalMetrics);
        if (this.lifecyclePhase == LifecyclePhase.STARTED) {
            newMetrics.start();
        }
        this.snapshotService.addPlatformMetric(newMetrics);
        if (!SettingsCommon.disableMetricsOutput) {
            String folderName = SettingsCommon.csvOutputFolder;
            Path folderPath = Path.of(StringUtils.isBlank((CharSequence)folderName) ? System.getProperty(USER_DIR) : folderName, new String[0]);
            if (StringUtils.isNotBlank((CharSequence)SettingsCommon.csvFileName)) {
                LegacyCsvWriter legacyCsvWriter = new LegacyCsvWriter(nodeId, folderPath);
                this.snapshotService.subscribe(legacyCsvWriter::handleSnapshots);
            }
            if (this.prometheusEndpoint != null) {
                newMetrics.subscribe(this.prometheusEndpoint::handleMetricsChange);
            }
        }
        return newMetrics;
    }

    @Override
    public LifecyclePhase getLifecyclePhase() {
        return this.lifecyclePhase;
    }

    @Override
    public void start() {
        if (this.lifecyclePhase == LifecyclePhase.NOT_STARTED) {
            this.globalMetrics.start();
            for (DefaultMetrics metrics : this.platformMetrics.values()) {
                metrics.start();
            }
            this.snapshotService.start();
            this.lifecyclePhase = LifecyclePhase.STARTED;
        }
    }

    @Override
    public void stop() {
        if (this.lifecyclePhase == LifecyclePhase.STARTED) {
            this.snapshotService.shutdown();
            this.prometheusEndpoint.close();
            this.lifecyclePhase = LifecyclePhase.STOPPED;
        }
    }
}

