/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.common.metrics.platform.AbstractDistributionMetric;
import com.swirlds.common.statistics.StatsBuffered;
import com.swirlds.common.statistics.StatsRunningAverage;
import com.swirlds.common.time.OSTime;
import com.swirlds.common.time.Time;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class DefaultRunningAverageMetric
extends AbstractDistributionMetric
implements RunningAverageMetric {
    private final StatsRunningAverage runningAverage;

    public DefaultRunningAverageMetric(RunningAverageMetric.Config config) {
        this(config, OSTime.getInstance());
    }

    public DefaultRunningAverageMetric(RunningAverageMetric.Config config, Time time) {
        super(config, config.getHalfLife());
        this.runningAverage = new StatsRunningAverage(this.halfLife, time);
    }

    @Override
    public StatsBuffered getStatsBuffered() {
        return this.runningAverage;
    }

    @Override
    public void update(double value) {
        this.runningAverage.recordValue(value);
    }

    @Override
    public double get() {
        return this.runningAverage.getWeightedMean();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("halfLife", this.halfLife).append("value", this.get()).toString();
    }
}

