/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.common.internal.SettingsCommon;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.StatEntry;
import com.swirlds.common.metrics.platform.DefaultMetric;
import com.swirlds.common.metrics.platform.Snapshot;
import com.swirlds.common.statistics.StatsBuffered;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class DefaultStatEntry
extends DefaultMetric
implements StatEntry {
    private final Metric.DataType dataType;
    private final StatsBuffered buffered;
    private final Consumer<Double> reset;
    private final Supplier<Object> statsStringSupplier;
    private final Supplier<Object> resetStatsStringSupplier;

    public DefaultStatEntry(StatEntry.Config<?> config) {
        super(config);
        this.dataType = MetricConfig.mapDataType(config.getType());
        this.buffered = config.getBuffered();
        this.reset = config.getReset();
        this.statsStringSupplier = config.getStatsStringSupplier();
        this.resetStatsStringSupplier = config.getResetStatsStringSupplier();
        if (config.getInit() != null) {
            config.getInit().apply(SettingsCommon.halfLife);
        }
    }

    @Override
    public Metric.DataType getDataType() {
        return this.dataType;
    }

    @Override
    public StatsBuffered getBuffered() {
        return this.buffered;
    }

    @Override
    public Consumer<Double> getReset() {
        return this.reset;
    }

    @Override
    public Supplier<Object> getStatsStringSupplier() {
        return this.statsStringSupplier;
    }

    @Override
    public Supplier<Object> getResetStatsStringSupplier() {
        return this.resetStatsStringSupplier;
    }

    @Override
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        if (this.buffered == null) {
            return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, this.resetStatsStringSupplier.get()));
        }
        double max = this.buffered.getMax();
        double min = this.buffered.getMin();
        double stdDev = this.buffered.getStdDev();
        Object value = this.resetStatsStringSupplier.get();
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, value), new Snapshot.SnapshotEntry(Metric.ValueType.MAX, max), new Snapshot.SnapshotEntry(Metric.ValueType.MIN, min), new Snapshot.SnapshotEntry(Metric.ValueType.STD_DEV, stdDev));
    }

    @Override
    public void reset() {
        if (this.reset != null) {
            this.reset.accept(SettingsCommon.halfLife);
        } else if (this.buffered != null) {
            this.buffered.reset(SettingsCommon.halfLife);
        }
    }

    @Override
    public StatsBuffered getStatsBuffered() {
        return this.getBuffered();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("value", this.statsStringSupplier.get()).toString();
    }
}

