/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.sequence.map;

import com.swirlds.common.sequence.map.internal.AbstractSequenceMap;
import com.swirlds.common.threading.locks.IndexLock;
import com.swirlds.common.threading.locks.Locks;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.ToLongFunction;

public class ConcurrentSequenceMap<K, V>
extends AbstractSequenceMap<K, V> {
    private static final int MAX_PARALLELISM = 1024;
    private final AtomicLong firstSequenceNumberInWindow;
    private final int parallelism;
    private final IndexLock lock;
    private final Lock windowLock = new ReentrantLock();

    public ConcurrentSequenceMap(long firstSequenceNumberInWindow, int sequenceNumberCapacity, ToLongFunction<K> getSequenceNumberFromKey) {
        super(firstSequenceNumberInWindow, sequenceNumberCapacity, getSequenceNumberFromKey);
        this.parallelism = Math.min(1024, sequenceNumberCapacity);
        this.lock = Locks.createIndexLock(this.parallelism);
        this.firstSequenceNumberInWindow = new AtomicLong(firstSequenceNumberInWindow);
    }

    @Override
    protected void lockSequenceNumber(long sequenceNumber) {
        this.lock.lock(sequenceNumber);
    }

    @Override
    protected void unlockSequenceNumber(long sequenceNumber) {
        this.lock.unlock(sequenceNumber);
    }

    @Override
    protected void fullLock() {
        this.lock.fullyLock();
    }

    @Override
    protected void fullUnlock() {
        this.lock.fullyUnlock();
    }

    @Override
    protected int getFullLockThreshold() {
        return this.parallelism;
    }

    @Override
    protected void windowLock() {
        this.windowLock.lock();
    }

    @Override
    protected void windowUnlock() {
        this.windowLock.unlock();
    }

    @Override
    public long getFirstSequenceNumberInWindow() {
        return this.firstSequenceNumberInWindow.get();
    }

    @Override
    protected void setFirstSequenceNumberInWindow(long firstSequenceNumberInWindow) {
        this.firstSequenceNumberInWindow.set(firstSequenceNumberInWindow);
    }

    @Override
    protected Map<K, V> buildDataMap() {
        return new ConcurrentHashMap();
    }
}

