/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system;

import com.swirlds.common.system.events.ConsensusEvent;
import com.swirlds.common.system.transaction.ConsensusTransaction;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public interface Round
extends Iterable<ConsensusEvent> {
    @Override
    public Iterator<ConsensusEvent> iterator();

    public long getRoundNum();

    public boolean isEmpty();

    public int getEventCount();

    default public void forEachTransaction(Consumer<ConsensusTransaction> transactionConsumer) {
        for (ConsensusEvent event : this) {
            Iterator<ConsensusTransaction> transIt = event.consensusTransactionIterator();
            while (transIt.hasNext()) {
                transactionConsumer.accept(transIt.next());
            }
        }
    }

    default public void forEachEventTransaction(BiConsumer<ConsensusEvent, ConsensusTransaction> consumer) {
        for (ConsensusEvent event : this) {
            Iterator<ConsensusTransaction> transIt = event.consensusTransactionIterator();
            while (transIt.hasNext()) {
                consumer.accept(event, transIt.next());
            }
        }
    }
}

