/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.address;

import com.swirlds.common.crypto.SerializablePublicKey;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.utility.NonCryptographicHashing;
import java.io.IOException;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Objects;

public class Address
implements SelfSerializable {
    private static final long CLASS_ID = 408980092978607982L;
    private static final int CLASS_VERSION = 3;
    private static final byte[] ALL_INTERFACES = new byte[]{0, 0, 0, 0};
    private static final int MAX_IP_LENGTH = 16;
    private static final int STRING_MAX_BYTES = 512;
    private long id;
    private String nickname;
    private String selfName;
    private boolean ownHost;
    private long stake;
    private byte[] addressInternalIpv4;
    private int portInternalIpv4;
    private byte[] addressExternalIpv4;
    private int portExternalIpv4;
    private byte[] addressInternalIpv6;
    private int portInternalIpv6;
    private int portExternalIpv6;
    private byte[] addressExternalIpv6;
    private SerializablePublicKey sigPublicKey;
    private SerializablePublicKey encPublicKey;
    private SerializablePublicKey agreePublicKey;
    private String memo;

    public Address() {
        this(-1L, "", "", 1L, false, null, -1, null, -1, null, -1, null, -1, (SerializablePublicKey)null, (SerializablePublicKey)null, (SerializablePublicKey)null, null);
    }

    public Address(long id, String nickname, String selfName, long stake, boolean ownHost, byte[] addressInternalIpv4, int portInternalIpv4, byte[] addressExternalIpv4, int portExternalIpv4, String memo) {
        this(id, nickname, selfName, stake, ownHost, addressInternalIpv4, portInternalIpv4, addressExternalIpv4, portExternalIpv4, null, -1, null, -1, null, null, (SerializablePublicKey)null, memo);
    }

    private byte[] clone(byte[] x) {
        return x == null ? x : (byte[])x.clone();
    }

    @Deprecated
    public Address(long id, String nickname, String selfName, long stake, boolean ownHost, byte[] addressInternalIpv4, int portInternalIpv4, byte[] addressExternalIpv4, int portExternalIpv4, byte[] addressInternalIpv6, int portInternalIpv6, byte[] addressExternalIpv6, int portExternalIpv6, PublicKey sigPublicKey, PublicKey encPublicKey, PublicKey agreePublicKey, String memo) {
        this(id, nickname, selfName, stake, ownHost, addressInternalIpv4, portInternalIpv4, addressExternalIpv4, portExternalIpv4, addressInternalIpv6, portInternalIpv6, addressExternalIpv6, portExternalIpv6, sigPublicKey == null ? null : new SerializablePublicKey(sigPublicKey), encPublicKey == null ? null : new SerializablePublicKey(encPublicKey), agreePublicKey == null ? null : new SerializablePublicKey(agreePublicKey), memo);
    }

    public Address(long id, String nickname, String selfName, long stake, boolean ownHost, byte[] addressInternalIpv4, int portInternalIpv4, byte[] addressExternalIpv4, int portExternalIpv4, byte[] addressInternalIpv6, int portInternalIpv6, byte[] addressExternalIpv6, int portExternalIpv6, SerializablePublicKey sigPublicKey, SerializablePublicKey encPublicKey, SerializablePublicKey agreePublicKey, String memo) {
        this.id = id;
        this.nickname = nickname;
        this.selfName = selfName;
        this.stake = stake;
        this.ownHost = ownHost;
        this.portInternalIpv4 = portInternalIpv4;
        this.portInternalIpv6 = portInternalIpv6;
        this.portExternalIpv4 = portExternalIpv4;
        this.portExternalIpv6 = portExternalIpv6;
        this.addressInternalIpv4 = this.clone(addressInternalIpv4);
        this.addressInternalIpv6 = this.clone(addressInternalIpv6);
        this.addressExternalIpv4 = this.clone(addressExternalIpv4);
        this.addressExternalIpv6 = this.clone(addressExternalIpv6);
        this.sigPublicKey = sigPublicKey;
        this.encPublicKey = encPublicKey;
        this.agreePublicKey = agreePublicKey;
        this.memo = memo;
    }

    @Override
    public int getVersion() {
        return 3;
    }

    @Override
    public long getClassId() {
        return 408980092978607982L;
    }

    public long getStake() {
        return this.stake;
    }

    public boolean isZeroStake() {
        return this.stake == 0L;
    }

    public long getId() {
        return this.id;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getSelfName() {
        return this.selfName;
    }

    public boolean isOwnHost() {
        return this.ownHost;
    }

    public int getConnectPortIpv4(Address a) {
        return this.isLocalTo(a) ? this.getPortInternalIpv4() : this.getPortExternalIpv4();
    }

    public boolean isLocalTo(Address a) {
        return Arrays.equals(this.getAddressExternalIpv4(), a.getAddressExternalIpv4());
    }

    public byte[] getListenAddressIpv4() {
        return ALL_INTERFACES;
    }

    public int getListenPortIpv4() {
        return this.getPortInternalIpv4();
    }

    public int getPortInternalIpv4() {
        return this.portInternalIpv4;
    }

    public int getPortInternalIpv6() {
        return this.portInternalIpv6;
    }

    public int getPortExternalIpv4() {
        return this.portExternalIpv4;
    }

    public int getPortExternalIpv6() {
        return this.portExternalIpv6;
    }

    public byte[] getAddressInternalIpv4() {
        return this.clone(this.addressInternalIpv4);
    }

    public byte[] getAddressInternalIpv6() {
        return this.clone(this.addressInternalIpv6);
    }

    public byte[] getAddressExternalIpv4() {
        return this.clone(this.addressExternalIpv4);
    }

    public byte[] getAddressExternalIpv6() {
        return this.clone(this.addressExternalIpv6);
    }

    public PublicKey getSigPublicKey() {
        return this.sigPublicKey.getPublicKey();
    }

    public PublicKey getEncPublicKey() {
        return this.encPublicKey.getPublicKey();
    }

    public PublicKey getAgreePublicKey() {
        return this.agreePublicKey.getPublicKey();
    }

    public String getMemo() {
        return this.memo;
    }

    public Address copySetId(long id) {
        Address a = this.copy();
        a.id = id;
        return a;
    }

    public Address copySetStake(long stake) {
        Address a = this.copy();
        a.stake = stake;
        return a;
    }

    public Address copySetNickname(String nickname) {
        Address a = this.copy();
        a.nickname = nickname;
        return a;
    }

    public Address copySetSelfName(String selfName) {
        Address a = this.copy();
        a.selfName = selfName;
        return a;
    }

    public Address copySetOwnHost(boolean ownHost) {
        Address a = this.copy();
        a.ownHost = ownHost;
        return a;
    }

    public Address copySetPortInternalIpv4(int portInternalIpv4) {
        Address a = this.copy();
        a.portInternalIpv4 = portInternalIpv4;
        return a;
    }

    public Address copySetPortInternalIpv6(int portInternalIpv6) {
        Address a = this.copy();
        a.portInternalIpv6 = portInternalIpv6;
        return a;
    }

    public Address copySetPortExternalIpv4(int portExternalIpv4) {
        Address a = this.copy();
        a.portExternalIpv4 = portExternalIpv4;
        return a;
    }

    public Address copySetPortExternalIpv6(int portExternalIpv6) {
        Address a = this.copy();
        a.portExternalIpv6 = portExternalIpv6;
        return a;
    }

    public Address copySetAddressInternalIpv4(byte[] AddressInternalIpv4) {
        Address a = this.copy();
        a.addressInternalIpv4 = this.clone(AddressInternalIpv4);
        return a;
    }

    public Address copySetAddressInternalIpv6(byte[] AddressInternalIpv6) {
        Address a = this.copy();
        a.addressInternalIpv6 = this.clone(AddressInternalIpv6);
        return a;
    }

    public Address copySetAddressExternalIpv4(byte[] AddressExternalIpv4) {
        Address a = this.copy();
        a.addressExternalIpv4 = this.clone(AddressExternalIpv4);
        return a;
    }

    public Address copySetAddressExternalIpv6(byte[] AddressExternalIpv6) {
        Address a = this.copy();
        a.addressExternalIpv6 = this.clone(AddressExternalIpv6);
        return a;
    }

    public Address copySetSigPublicKey(PublicKey sigPublicKey) {
        Address a = this.copy();
        a.sigPublicKey = new SerializablePublicKey(sigPublicKey);
        return a;
    }

    public Address copySetEncPublicKey(PublicKey encPublicKey) {
        Address a = this.copy();
        a.encPublicKey = new SerializablePublicKey(encPublicKey);
        return a;
    }

    public Address copySetAgreePublicKey(PublicKey agreePublicKey) {
        Address a = this.copy();
        a.agreePublicKey = new SerializablePublicKey(agreePublicKey);
        return a;
    }

    public Address copy() {
        return new Address(this.id, this.nickname, this.selfName, this.stake, this.ownHost, this.addressInternalIpv4, this.portInternalIpv4, this.addressExternalIpv4, this.portExternalIpv4, this.addressInternalIpv6, this.portInternalIpv6, this.addressExternalIpv6, this.portExternalIpv6, this.sigPublicKey, this.encPublicKey, this.agreePublicKey, this.memo);
    }

    @Deprecated
    public void writeAddress(SerializableDataOutputStream outStream) throws IOException {
        this.serialize(outStream);
    }

    @Deprecated(forRemoval=true)
    public static Address readAddress(SerializableDataInputStream inStream, long version) throws IOException {
        Address address = new Address();
        address.deserialize(inStream, (int)version);
        return address;
    }

    @Override
    public void serialize(SerializableDataOutputStream outStream) throws IOException {
        outStream.writeLong(this.id);
        outStream.writeNormalisedString(this.nickname);
        outStream.writeNormalisedString(this.selfName);
        outStream.writeLong(this.stake);
        outStream.writeByteArray(this.addressInternalIpv4);
        outStream.writeInt(this.portInternalIpv4);
        outStream.writeByteArray(this.addressExternalIpv4);
        outStream.writeInt(this.portExternalIpv4);
        outStream.writeByteArray(this.addressInternalIpv6);
        outStream.writeInt(this.portInternalIpv6);
        outStream.writeByteArray(this.addressExternalIpv6);
        outStream.writeInt(this.portExternalIpv6);
        outStream.writeSerializable(this.sigPublicKey, false);
        outStream.writeSerializable(this.encPublicKey, false);
        outStream.writeSerializable(this.agreePublicKey, false);
        outStream.writeNormalisedString(this.memo);
    }

    @Override
    public void deserialize(SerializableDataInputStream inStream, int version) throws IOException {
        this.id = inStream.readLong();
        this.nickname = inStream.readNormalisedString(512);
        this.selfName = inStream.readNormalisedString(512);
        this.stake = inStream.readLong();
        this.ownHost = false;
        this.addressInternalIpv4 = inStream.readByteArray(16);
        this.portInternalIpv4 = inStream.readInt();
        this.addressExternalIpv4 = inStream.readByteArray(16);
        this.portExternalIpv4 = inStream.readInt();
        this.addressInternalIpv6 = inStream.readByteArray(16);
        this.portInternalIpv6 = inStream.readInt();
        this.addressExternalIpv6 = inStream.readByteArray(16);
        this.portExternalIpv6 = inStream.readInt();
        switch (version) {
            case 1: {
                this.sigPublicKey = new SerializablePublicKey();
                this.encPublicKey = new SerializablePublicKey();
                this.agreePublicKey = new SerializablePublicKey();
                this.sigPublicKey.deserializeVersion0(inStream, "RSA");
                this.encPublicKey.deserializeVersion0(inStream, "EC");
                this.agreePublicKey.deserializeVersion0(inStream, "EC");
                break;
            }
            case 2: {
                this.sigPublicKey = new SerializablePublicKey();
                this.encPublicKey = new SerializablePublicKey();
                this.agreePublicKey = new SerializablePublicKey();
                this.sigPublicKey.deserialize(inStream, 1);
                this.encPublicKey.deserialize(inStream, 1);
                this.agreePublicKey.deserialize(inStream, 1);
                break;
            }
            default: {
                this.sigPublicKey = inStream.readSerializable(false, SerializablePublicKey::new);
                this.encPublicKey = inStream.readSerializable(false, SerializablePublicKey::new);
                this.agreePublicKey = inStream.readSerializable(false, SerializablePublicKey::new);
            }
        }
        this.memo = inStream.readNormalisedString(512);
    }

    public static String ipString(byte[] ip) {
        return (0xFF & ip[0]) + "." + (0xFF & ip[1]) + "." + (0xFF & ip[2]) + "." + (0xFF & ip[3]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return this.id == address.id && this.ownHost == address.ownHost && this.stake == address.stake && this.portInternalIpv4 == address.portInternalIpv4 && this.portExternalIpv4 == address.portExternalIpv4 && this.portInternalIpv6 == address.portInternalIpv6 && this.portExternalIpv6 == address.portExternalIpv6 && Objects.equals(this.nickname, address.nickname) && Objects.equals(this.selfName, address.selfName) && Arrays.equals(this.addressInternalIpv4, address.addressInternalIpv4) && Arrays.equals(this.addressExternalIpv4, address.addressExternalIpv4) && Arrays.equals(this.addressInternalIpv6, address.addressInternalIpv6) && Arrays.equals(this.addressExternalIpv6, address.addressExternalIpv6) && Objects.equals(this.sigPublicKey, address.sigPublicKey) && Objects.equals(this.encPublicKey, address.encPublicKey) && Objects.equals(this.agreePublicKey, address.agreePublicKey) && Objects.equals(this.memo, address.memo);
    }

    public int hashCode() {
        return NonCryptographicHashing.hash32(this.id);
    }

    public String toString() {
        return "Address{id=" + this.id + ", nickname='" + this.nickname + "', selfName='" + this.selfName + "', ownHost=" + this.ownHost + ", stake=" + this.stake + ", addressInternalIpv4=" + Arrays.toString(this.addressInternalIpv4) + ", portInternalIpv4=" + this.portInternalIpv4 + ", addressExternalIpv4=" + Arrays.toString(this.addressExternalIpv4) + ", portExternalIpv4=" + this.portExternalIpv4 + ", addressInternalIpv6=" + Arrays.toString(this.addressInternalIpv6) + ", portInternalIpv6=" + this.portInternalIpv6 + ", portExternalIpv6=" + this.portExternalIpv6 + ", addressExternalIpv6=" + Arrays.toString(this.addressExternalIpv6) + ", sigPublicKey=" + this.sigPublicKey + ", encPublicKey=" + this.encPublicKey + ", agreePublicKey=" + this.agreePublicKey + ", memo='" + this.memo + "'}";
    }
}

