/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.address;

import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.impl.PartialMerkleLeaf;
import com.swirlds.common.system.address.Address;
import com.swirlds.common.system.address.internal.AddressBookIterator;
import com.swirlds.common.utility.CommonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public class AddressBook
extends PartialMerkleLeaf
implements Iterable<Address>,
MerkleLeaf {
    public static final long CLASS_ID = 5685030982988856288L;
    public static final int MAX_ADDRESSES = 1024;
    public static final int FIRST_NODE_ID = 0;
    public static final long UNKNOWN_ROUND = Long.MIN_VALUE;
    private long round = Long.MIN_VALUE;
    private long nextNodeId = 0L;
    private final Map<Long, Address> addresses = new HashMap<Long, Address>();
    private final Map<String, Long> publicKeyToId = new HashMap<String, Long>();
    private final Map<Long, Integer> nodeIndices = new HashMap<Long, Integer>();
    private final List<Long> orderedNodeIds = new ArrayList<Long>();
    private long totalStake;
    private int numberWithStake;

    public AddressBook() {
        this(new ArrayList<Address>());
    }

    private AddressBook(AddressBook that) {
        super(that);
        for (Address address : that) {
            this.addNewAddress(address);
        }
        this.round = that.round;
    }

    public AddressBook(List<Address> addresses) {
        addresses.forEach(this::add);
    }

    @Override
    public int getVersion() {
        return 4;
    }

    @Override
    public long getClassId() {
        return 5685030982988856288L;
    }

    public long getRound() {
        return this.round;
    }

    public AddressBook setRound(long round) {
        this.throwIfImmutable();
        this.round = round;
        return this;
    }

    public int getSize() {
        return this.addresses.size();
    }

    public boolean isEmpty() {
        return this.addresses.isEmpty();
    }

    public int getNumberWithStake() {
        return this.numberWithStake;
    }

    public long getTotalStake() {
        return this.totalStake;
    }

    public long getId(String publicKey) {
        return this.publicKeyToId.getOrDefault(publicKey, -1L);
    }

    public long getId(int index) {
        if (index < 0 || index >= this.addresses.size()) {
            throw new NoSuchElementException("no address with index " + index + " exists");
        }
        return this.orderedNodeIds.get(index);
    }

    public int getIndex(long id) {
        return this.nodeIndices.get(id);
    }

    public long getNextNodeId() {
        return this.nextNodeId;
    }

    public AddressBook setNextNodeId(long nextNodeId) {
        for (Address address : this) {
            if (address.getId() < nextNodeId) continue;
            throw new IllegalArgumentException("This address book contains an address " + address + " with a node ID that is greater or equal to " + nextNodeId);
        }
        this.nextNodeId = nextNodeId;
        return this;
    }

    public Address getAddress(long id) {
        return this.addresses.get(id);
    }

    public boolean contains(long id) {
        return this.addresses.containsKey(id);
    }

    private void addToOrderedList(long nodeId) {
        int index = this.orderedNodeIds.size();
        this.orderedNodeIds.add(nodeId);
        this.nodeIndices.put(nodeId, index);
    }

    private void removeNodeFromOrderedList(long nodeId) {
        int indexToRemove = this.nodeIndices.remove(nodeId);
        this.orderedNodeIds.remove(indexToRemove);
        for (int index = indexToRemove; index < this.orderedNodeIds.size(); ++index) {
            this.nodeIndices.put(this.orderedNodeIds.get(index), index);
        }
    }

    private void updateAddress(Address address) {
        Address oldAddress = Objects.requireNonNull(this.addresses.put(address.getId(), address));
        this.publicKeyToId.remove(oldAddress.getNickname());
        this.publicKeyToId.put(address.getNickname(), address.getId());
        long oldStake = oldAddress.getStake();
        long newStake = address.getStake();
        this.totalStake -= oldStake;
        this.totalStake += newStake;
        if (oldStake == 0L && newStake != 0L) {
            ++this.numberWithStake;
        } else if (oldStake != 0L && newStake == 0L) {
            --this.numberWithStake;
        }
        this.addresses.put(address.getId(), address);
    }

    private void addNewAddress(Address address) {
        if (address.getId() < this.nextNodeId) {
            throw new IllegalStateException("Can not add address for node with ID " + address.getId() + ", the next address to be added is required have a node ID greater or equal to " + this.nextNodeId);
        }
        if (this.addresses.size() >= 1024) {
            throw new IllegalStateException("Address book is only permitted to hold 1024 entries");
        }
        this.nextNodeId = address.getId() + 1L;
        this.addresses.put(address.getId(), address);
        this.publicKeyToId.put(address.getNickname(), address.getId());
        this.addToOrderedList(address.getId());
        this.totalStake += address.getStake();
        if (!address.isZeroStake()) {
            ++this.numberWithStake;
        }
    }

    public AddressBook add(Address address) {
        this.throwIfImmutable();
        CommonUtils.throwArgNull(address, "address");
        if (this.addresses.containsKey(address.getId())) {
            this.updateAddress(address);
        } else {
            this.addNewAddress(address);
        }
        return this;
    }

    public AddressBook remove(long id) {
        this.throwIfImmutable();
        Address address = this.addresses.remove(id);
        if (address == null) {
            return this;
        }
        this.publicKeyToId.remove(address.getNickname());
        this.removeNodeFromOrderedList(id);
        this.totalStake -= address.getStake();
        if (!address.isZeroStake()) {
            --this.numberWithStake;
        }
        this.orderedNodeIds.remove(id);
        return this;
    }

    public void clear() {
        this.throwIfImmutable();
        this.addresses.clear();
        this.publicKeyToId.clear();
        this.nodeIndices.clear();
        this.orderedNodeIds.clear();
        this.totalStake = 0L;
        this.numberWithStake = 0;
        this.nextNodeId = 0L;
    }

    @Override
    public AddressBook copy() {
        return new AddressBook(this);
    }

    public AddressBook seal() {
        this.setImmutable(true);
        return this;
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeSerializableIterableWithSize(this.iterator(), this.addresses.size(), false, true);
        out.writeLong(this.round);
        out.writeLong(this.nextNodeId);
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        in.readSerializableIterableWithSize(1024, false, Address::new, this::addNewAddress);
        if (version < 4) {
            this.round = Long.MIN_VALUE;
            if (!this.orderedNodeIds.isEmpty()) {
                this.nextNodeId = this.orderedNodeIds.get(this.getSize() - 1) + 1L;
            }
            return;
        }
        this.round = in.readLong();
        this.nextNodeId = in.readLong();
    }

    @Override
    public int getMinimumSupportedVersion() {
        return 3;
    }

    @Override
    public Iterator<Address> iterator() {
        return new AddressBookIterator(this.orderedNodeIds.iterator(), this.addresses);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressBook that = (AddressBook)o;
        return Objects.equals(this.addresses, that.addresses) && this.getRound() == that.getRound() && this.getNextNodeId() == that.getNextNodeId();
    }

    public int hashCode() {
        return this.addresses.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AddressBook {\n");
        for (Address address : this) {
            sb.append("   ").append(address).append(",\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 0;
        public static final int UNDOCUMENTED = 1;
        public static final int AD_HOC_SERIALIZATION = 2;
        public static final int UTILITY_SERIALIZATION = 3;
        public static final int ADDRESS_BOOK_STORE_SUPPORT = 4;

        private ClassVersion() {
        }
    }
}

