/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.address;

import com.swirlds.common.system.address.Address;
import com.swirlds.common.system.address.AddressBook;
import com.swirlds.logging.LogMarker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AddressBookValidator {
    private static final Logger logger = LogManager.getLogger(AddressBookValidator.class);

    private AddressBookValidator() {
    }

    public static boolean hasNonZeroStake(AddressBook addressBook) {
        if (addressBook.getTotalStake() <= 0L) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "address book for round {} has {} total stake", (Object)addressBook.getRound(), (Object)addressBook.getTotalStake());
            return false;
        }
        return true;
    }

    public static boolean isNonEmpty(AddressBook addressBook) {
        if (addressBook.getSize() == 0) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "address book for round {} is empty", (Object)addressBook.getRound());
            return false;
        }
        return true;
    }

    public static boolean validNextId(AddressBook previousAddressBook, AddressBook addressBook) {
        if (previousAddressBook.getNextNodeId() > addressBook.getNextNodeId()) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Invalid next node ID. Previous address book has a next node ID of {}, new address book has a next node ID of {}", (Object)previousAddressBook.getNextNodeId(), (Object)addressBook.getNextNodeId());
            return false;
        }
        return true;
    }

    public static boolean noAddressReinsertion(AddressBook previousAddressBook, AddressBook addressBook) {
        long previousNextId = previousAddressBook.getNextNodeId();
        for (Address address : addressBook) {
            long nodeId = address.getId();
            if (nodeId >= previousNextId || previousAddressBook.contains(nodeId)) continue;
            logger.error(LogMarker.EXCEPTION.getMarker(), "Once an address is removed or a node ID is skipped, an address with that some node ID may never be added again. Invalid node ID = {}", (Object)nodeId);
            return false;
        }
        return true;
    }

    public static boolean isGenesisAddressBookValid(AddressBook candidateAddressBook) {
        return AddressBookValidator.hasNonZeroStake(candidateAddressBook) && AddressBookValidator.isNonEmpty(candidateAddressBook);
    }

    public static boolean isNextAddressBookValid(AddressBook previousAddressBook, AddressBook candidateAddressBook) {
        return AddressBookValidator.hasNonZeroStake(candidateAddressBook) && AddressBookValidator.isNonEmpty(candidateAddressBook) && AddressBookValidator.validNextId(previousAddressBook, candidateAddressBook) && AddressBookValidator.noAddressReinsertion(previousAddressBook, candidateAddressBook);
    }
}

