/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.framework.internal;

import com.swirlds.common.threading.framework.QueueThread;
import com.swirlds.common.threading.framework.Stoppable;
import com.swirlds.common.threading.framework.internal.AbstractStoppableThreadConfiguration;
import com.swirlds.common.threading.framework.internal.QueueThreadImpl;
import com.swirlds.common.threading.interrupt.InterruptableConsumer;
import com.swirlds.common.threading.interrupt.InterruptableRunnable;
import com.swirlds.common.threading.manager.ThreadManager;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class AbstractQueueThreadConfiguration<C extends AbstractQueueThreadConfiguration<C, T>, T>
extends AbstractStoppableThreadConfiguration<C, InterruptableRunnable> {
    public static final int DEFAULT_CAPACITY = 100;
    public static final int DEFAULT_MAX_BUFFER_SIZE = 10000;
    public static final int UNLIMITED_CAPACITY = -1;
    private int capacity = 100;
    private int maxBufferSize = 10000;
    private InterruptableConsumer<T> handler;
    private InterruptableRunnable waitForItemRunnable;
    private BlockingQueue<T> queue;

    protected AbstractQueueThreadConfiguration(ThreadManager threadManager) {
        super(threadManager);
        this.setStopBehavior(Stoppable.StopBehavior.BLOCKING);
    }

    protected AbstractQueueThreadConfiguration(AbstractQueueThreadConfiguration<C, T> that) {
        super(that);
        this.capacity = that.capacity;
        this.maxBufferSize = that.maxBufferSize;
        this.handler = that.handler;
        this.waitForItemRunnable = that.waitForItemRunnable;
        this.queue = that.queue;
    }

    @Override
    public abstract AbstractQueueThreadConfiguration<C, T> copy();

    protected QueueThread<T> buildQueueThread(boolean start) {
        QueueThreadImpl thread = new QueueThreadImpl(this);
        if (start) {
            thread.start();
        }
        return thread;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public C setCapacity(int capacity) {
        this.throwIfImmutable();
        this.capacity = capacity;
        return (C)this;
    }

    public C setUnlimitedCapacity() {
        this.throwIfImmutable();
        this.capacity = -1;
        return (C)this;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public C setMaxBufferSize(int maxBufferSize) {
        this.throwIfImmutable();
        this.maxBufferSize = maxBufferSize;
        return (C)this;
    }

    protected InterruptableConsumer<T> getHandler() {
        return this.handler;
    }

    protected C setHandler(InterruptableConsumer<T> handler) {
        this.throwIfImmutable();
        this.handler = handler;
        return (C)this;
    }

    public InterruptableRunnable getWaitForItemRunnable() {
        return this.waitForItemRunnable;
    }

    public C setWaitForItemRunnable(InterruptableRunnable waitForItemRunnable) {
        this.throwIfImmutable();
        this.waitForItemRunnable = waitForItemRunnable;
        return (C)this;
    }

    private BlockingQueue<T> buildDefaultQueue() {
        if (this.capacity > 0) {
            return new LinkedBlockingQueue(this.capacity);
        }
        return new LinkedBlockingQueue();
    }

    protected BlockingQueue<T> getOrInitializeQueue() {
        if (this.getQueue() == null) {
            this.setQueue(this.buildDefaultQueue());
        }
        return this.getQueue();
    }

    public BlockingQueue<T> getQueue() {
        return this.queue;
    }

    public C setQueue(BlockingQueue<T> queue) {
        this.throwIfImmutable();
        this.queue = queue;
        return (C)this;
    }
}

