/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.framework.internal;

import com.swirlds.common.threading.framework.QueueThread;
import com.swirlds.common.threading.framework.Stoppable;
import com.swirlds.common.threading.framework.StoppableThread;
import com.swirlds.common.threading.framework.ThreadSeed;
import com.swirlds.common.threading.framework.internal.AbstractBlockingQueue;
import com.swirlds.common.threading.framework.internal.AbstractQueueThreadConfiguration;
import com.swirlds.common.threading.framework.internal.StoppableThreadImpl;
import com.swirlds.common.threading.interrupt.InterruptableConsumer;
import com.swirlds.common.threading.interrupt.InterruptableRunnable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class QueueThreadImpl<T>
extends AbstractBlockingQueue<T>
implements QueueThread<T> {
    private static final int WAIT_FOR_WORK_DELAY_MS = 10;
    private final int bufferSize;
    private final List<T> buffer;
    private final InterruptableConsumer<T> handler;
    private final StoppableThread stoppableThread;
    private final InterruptableRunnable waitForItemRunnable;
    private final AbstractQueueThreadConfiguration<?, T> configuration;

    public QueueThreadImpl(AbstractQueueThreadConfiguration<?, T> configuration) {
        super(configuration.getOrInitializeQueue());
        this.configuration = configuration;
        int capacity = configuration.getCapacity();
        this.bufferSize = capacity > 0 ? Math.min(capacity, configuration.getMaxBufferSize()) : configuration.getMaxBufferSize();
        this.buffer = new ArrayList<T>(this.bufferSize);
        this.handler = configuration.getHandler();
        this.waitForItemRunnable = Objects.requireNonNullElseGet(configuration.getWaitForItemRunnable(), () -> this::waitForItem);
        this.stoppableThread = ((AbstractQueueThreadConfiguration)((AbstractQueueThreadConfiguration)((AbstractQueueThreadConfiguration)configuration.setWork(this::doWork)).setStopBehavior(configuration.getStopBehavior())).setFinalCycleWork(this::doFinalCycleWork)).buildStoppableThread(false);
    }

    @Override
    public ThreadSeed buildSeed() {
        if (((StoppableThreadImpl)this.stoppableThread).hasBeenStartedOrInjected()) {
            throw new IllegalStateException("can not build seed for thread if it has already built a seed or if it has already been started");
        }
        return this.configuration.buildStoppableThreadSeed((StoppableThreadImpl)this.stoppableThread);
    }

    @Override
    public void start() {
        if (((StoppableThreadImpl)this.stoppableThread).hasBeenStartedOrInjected()) {
            throw new IllegalStateException("can not start thread if it has already built a seed or if it has already been started");
        }
        this.stoppableThread.start();
    }

    @Override
    public boolean pause() {
        return this.stoppableThread.pause();
    }

    @Override
    public boolean resume() {
        return this.stoppableThread.resume();
    }

    @Override
    public void join() throws InterruptedException {
        this.stoppableThread.join();
    }

    @Override
    public void join(long millis) throws InterruptedException {
        this.stoppableThread.join(millis);
    }

    @Override
    public void join(long millis, int nanos) throws InterruptedException {
        this.stoppableThread.join(millis, nanos);
    }

    @Override
    public boolean stop() {
        return this.stoppableThread.stop();
    }

    @Override
    public boolean stop(Stoppable.StopBehavior behavior) {
        return this.stoppableThread.stop(behavior);
    }

    @Override
    public boolean interrupt() {
        return this.stoppableThread.interrupt();
    }

    @Override
    public boolean isAlive() {
        return this.stoppableThread.isAlive();
    }

    @Override
    public StoppableThread.Status getStatus() {
        return this.stoppableThread.getStatus();
    }

    @Override
    public boolean isHanging() {
        return this.stoppableThread.isHanging();
    }

    private void doWork() throws InterruptedException {
        this.drainTo(this.buffer, this.bufferSize);
        if (this.buffer.size() == 0) {
            this.waitForItemRunnable.run();
            return;
        }
        for (T item : this.buffer) {
            this.handler.accept(item);
        }
        this.buffer.clear();
    }

    private void waitForItem() throws InterruptedException {
        Object item = this.poll(10L, TimeUnit.MILLISECONDS);
        if (item != null) {
            this.handler.accept(item);
        }
    }

    private void doFinalCycleWork() throws InterruptedException {
        while (!this.isEmpty()) {
            this.drainTo(this.buffer, this.bufferSize);
            for (T item : this.buffer) {
                this.handler.accept(item);
            }
            this.buffer.clear();
        }
    }

    @Override
    public void clear() {
        if (this.stoppableThread.getStatus() != StoppableThread.Status.ALIVE) {
            super.clear();
            return;
        }
        this.pause();
        super.clear();
        this.resume();
    }

    @Override
    public String getName() {
        return this.stoppableThread.getName();
    }

    public String toString() {
        return "QueueThread(" + this.getName() + ")";
    }
}

