/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.futures;

import com.swirlds.common.threading.futures.FutureUtils;
import com.swirlds.common.threading.futures.GapHandler;
import com.swirlds.common.threading.futures.StandardFuture;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.LongFunction;
import java.util.function.Supplier;

public class SequentialFutures<T> {
    private final Map<Long, StandardFuture<T>> futures = new HashMap<Long, StandardFuture<T>>();
    private final long numberOfValuesToStore;
    private final GapHandler<T> gapHandler;
    private long lowestUncompletedIndex;
    private long lowestUnremovedIndex;
    private T mostRecentValueCompleted;

    public SequentialFutures(long nextIndex, int numberOfValuesToStore, LongFunction<T> initialValues, GapHandler<T> gapHandler) {
        this.lowestUncompletedIndex = nextIndex;
        this.numberOfValuesToStore = numberOfValuesToStore;
        this.gapHandler = gapHandler;
        for (long sequence = this.lowestUnremovedIndex = nextIndex - (long)numberOfValuesToStore; sequence < nextIndex; ++sequence) {
            T initialValue = initialValues.apply(sequence);
            this.mostRecentValueCompleted = initialValue;
            this.futures.put(sequence, new StandardFuture<T>(initialValue));
        }
    }

    public Future<T> get(long index) {
        Future<T> future = this.getIfAvailable(index);
        if (future == null) {
            throw new IllegalStateException("requested index " + index + " is in the past and is unavailable");
        }
        return future;
    }

    public synchronized Future<T> getIfAvailable(long index) {
        long lowestAllowedIndex = this.lowestUncompletedIndex - this.numberOfValuesToStore;
        if (index < lowestAllowedIndex) {
            return null;
        }
        StandardFuture<T> future = this.futures.get(index);
        if (future != null) {
            return future;
        }
        StandardFuture newFuture = new StandardFuture();
        this.futures.put(index, newFuture);
        return newFuture;
    }

    public T getValue(long index) throws ExecutionException, InterruptedException {
        return this.get(index).get();
    }

    public T getValueIfAvailable(long index) throws ExecutionException, InterruptedException {
        Future<T> future = this.getIfAvailable(index);
        if (future == null) {
            return null;
        }
        try {
            return future.get();
        }
        catch (CancellationException exception) {
            return null;
        }
    }

    private void fillGaps(long index) {
        while (index != this.lowestUncompletedIndex) {
            StandardFuture future = this.futures.computeIfAbsent(this.lowestUncompletedIndex, i -> new StandardFuture());
            this.gapHandler.handleGap(this.lowestUncompletedIndex, future, this.mostRecentValueCompleted);
            if (!future.isCancelled() && future.isDone()) {
                this.mostRecentValueCompleted = FutureUtils.getImmediately(future);
            }
            ++this.lowestUncompletedIndex;
        }
    }

    private void pruneOldFutures() {
        while (this.lowestUncompletedIndex - this.lowestUnremovedIndex > this.numberOfValuesToStore) {
            this.futures.remove(this.lowestUnremovedIndex);
            ++this.lowestUnremovedIndex;
        }
    }

    private void assertCompletionIndexIsValid(long index) {
        if (index < this.lowestUncompletedIndex) {
            throw new IllegalStateException("futures must be completed in increasing order, expected index >= " + this.lowestUncompletedIndex + ", provided index = " + index);
        }
    }

    private void completeFuture(long index, Supplier<StandardFuture<T>> buildNewFuture, Consumer<StandardFuture<T>> updateExistingFuture) {
        this.assertCompletionIndexIsValid(index);
        this.fillGaps(index);
        StandardFuture<T> future = this.futures.get(this.lowestUncompletedIndex);
        if (future == null) {
            this.futures.put(index, buildNewFuture.get());
        } else {
            updateExistingFuture.accept(future);
        }
        ++this.lowestUncompletedIndex;
        this.pruneOldFutures();
    }

    public synchronized void complete(long index, T value) {
        this.completeFuture(index, () -> new StandardFuture<Object>(value), future -> future.complete(value));
        this.mostRecentValueCompleted = value;
    }

    public synchronized void cancel(long index) {
        this.completeFuture(index, () -> {
            StandardFuture future = new StandardFuture();
            future.cancel();
            return future;
        }, StandardFuture::cancel);
    }

    public synchronized void cancelWithError(long index, Throwable error) {
        this.completeFuture(index, () -> {
            StandardFuture future = new StandardFuture();
            future.cancelWithError(error);
            return future;
        }, future -> future.cancelWithError(error));
    }

    public synchronized void fastForwardIndex(long nextIndex, LongFunction<T> initialValues) {
        LinkedList futuresToRemove = new LinkedList();
        this.futures.forEach((round, future) -> {
            if (round < nextIndex - this.numberOfValuesToStore) {
                future.cancel();
                futuresToRemove.add(round);
            }
        });
        futuresToRemove.forEach(this.futures::remove);
        for (long index = nextIndex - this.numberOfValuesToStore; index < nextIndex; ++index) {
            StandardFuture<T> existingFuture = this.futures.get(index);
            T initialValue = initialValues.apply(index);
            if (existingFuture == null) {
                this.futures.put(index, new StandardFuture<T>(initialValue));
                this.mostRecentValueCompleted = initialValue;
                continue;
            }
            if (existingFuture.isDone() || existingFuture.isCancelled()) continue;
            existingFuture.complete(initialValue);
            this.mostRecentValueCompleted = initialValue;
        }
        this.lowestUncompletedIndex = nextIndex;
        this.lowestUnremovedIndex = nextIndex - this.numberOfValuesToStore;
    }
}

