/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.interrupt;

import com.swirlds.common.threading.interrupt.InterruptableRunnable;
import com.swirlds.common.threading.interrupt.InterruptableSupplier;
import com.swirlds.logging.LogMarker;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Uninterruptable {
    private static final Logger logger = LogManager.getLogger(Uninterruptable.class);

    private Uninterruptable() {
    }

    public static void retryIfInterrupted(InterruptableRunnable action) {
        boolean finished = false;
        boolean interrupted = false;
        while (!finished) {
            try {
                action.run();
                finished = true;
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static <T> T retryIfInterrupted(InterruptableSupplier<T> action) {
        boolean finished = false;
        boolean interrupted = false;
        T value = null;
        while (!finished) {
            try {
                value = action.get();
                finished = true;
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return value;
    }

    public static void abortIfInterrupted(InterruptableRunnable action) {
        try {
            action.run();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void abortAndLogIfInterrupted(InterruptableRunnable action, String errorMessage) {
        try {
            action.run();
        }
        catch (InterruptedException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), errorMessage);
            Thread.currentThread().interrupt();
        }
    }

    public static void abortAndThrowIfInterrupted(InterruptableRunnable action, String errorMessage) {
        try {
            action.run();
        }
        catch (InterruptedException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), errorMessage);
            Thread.currentThread().interrupt();
            throw new IllegalStateException(errorMessage);
        }
    }

    public static void tryToSleep(Duration duration) {
        Uninterruptable.abortIfInterrupted(() -> TimeUnit.MILLISECONDS.sleep(duration.toMillis()));
    }
}

