/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.locks.internal;

import com.swirlds.common.threading.locks.IndexLock;
import com.swirlds.common.threading.locks.locked.Locked;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DefaultIndexLock
implements IndexLock {
    private final int parallelism;
    private final Lock[] locks;

    public DefaultIndexLock(int parallelism) {
        this.parallelism = parallelism;
        this.locks = new Lock[parallelism];
        for (int lockIndex = 0; lockIndex < parallelism; ++lockIndex) {
            this.locks[lockIndex] = new ReentrantLock();
        }
    }

    @Override
    public void lock(long index) {
        this.locks[(int)(Math.abs(index) % (long)this.parallelism)].lock();
    }

    @Override
    public void lock(Object object) {
        int hash = object == null ? 0 : object.hashCode();
        this.lock(hash);
    }

    @Override
    public void unlock(long index) {
        this.locks[(int)(Math.abs(index) % (long)this.parallelism)].unlock();
    }

    @Override
    public void unlock(Object object) {
        int hash = object == null ? 0 : object.hashCode();
        this.unlock(hash);
    }

    @Override
    public Locked autoLock(long index) {
        this.lock(index);
        return () -> this.unlock(index);
    }

    @Override
    public Locked autoLock(Object object) {
        int hash = object == null ? 0 : object.hashCode();
        return this.autoLock(hash);
    }

    @Override
    public void fullyLock() {
        for (int index = 0; index < this.parallelism; ++index) {
            this.locks[index].lock();
        }
    }

    @Override
    public void fullyUnlock() {
        for (int index = 0; index < this.parallelism; ++index) {
            this.locks[index].unlock();
        }
    }

    @Override
    public Locked autoFullLock() {
        this.fullyLock();
        return this::fullyUnlock;
    }
}

