/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.locks.internal;

import com.swirlds.common.threading.locks.AutoClosableResourceLock;
import com.swirlds.common.threading.locks.internal.AcquiredResource;
import com.swirlds.common.threading.locks.internal.NotAcquiredResource;
import com.swirlds.common.threading.locks.locked.LockedResource;
import com.swirlds.common.threading.locks.locked.MaybeLockedResource;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class ResourceLock<T>
implements AutoClosableResourceLock<T> {
    private final Lock lock;
    private final MaybeLockedResource<T> acquired;
    private final MaybeLockedResource<T> notAcquired;

    public ResourceLock(Lock lock, T resource) {
        this.lock = lock;
        this.acquired = new AcquiredResource<T>(lock::unlock, resource);
        this.notAcquired = new NotAcquiredResource();
    }

    @Override
    public LockedResource<T> lock() {
        this.lock.lock();
        return this.acquired;
    }

    @Override
    public LockedResource<T> lockInterruptibly() throws InterruptedException {
        this.lock.lockInterruptibly();
        return this.acquired;
    }

    @Override
    public MaybeLockedResource<T> tryLock() {
        if (this.lock.tryLock()) {
            return this.acquired;
        }
        return this.notAcquired;
    }

    @Override
    public MaybeLockedResource<T> tryLock(long time, TimeUnit unit) throws InterruptedException {
        if (this.lock.tryLock(time, unit)) {
            return this.acquired;
        }
        return this.notAcquired;
    }

    @Override
    public Condition newCondition() {
        return this.lock.newCondition();
    }
}

