/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.pool;

import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.common.threading.pool.ParallelExecutionException;
import com.swirlds.common.threading.pool.ParallelExecutor;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public class CachedPoolParallelExecutor
implements ParallelExecutor {
    private static final Runnable NOOP = () -> {};
    private ExecutorService threadPool;
    private boolean immutable = false;
    private final ThreadFactory factory;

    public CachedPoolParallelExecutor(ThreadManager threadManager, String name) {
        this.factory = threadManager.createThreadFactory("parallel-executor", name);
    }

    @Override
    public boolean isImmutable() {
        return this.immutable;
    }

    @Override
    public void start() {
        this.throwIfImmutable("should only be started once");
        this.immutable = true;
        this.threadPool = Executors.newCachedThreadPool(this.factory);
    }

    @Override
    public <T> T doParallel(Callable<T> foregroundTask, Callable<Void> backgroundTask, Runnable onThrow) throws ParallelExecutionException {
        this.throwIfMutable("must be started first");
        Future<Void> future = this.threadPool.submit(backgroundTask);
        ParallelExecutionException toThrow = null;
        T result = null;
        try {
            result = foregroundTask.call();
        }
        catch (Throwable e) {
            toThrow = new ParallelExecutionException(e);
            onThrow.run();
        }
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if (toThrow == null) {
                toThrow = new ParallelExecutionException(e);
                onThrow.run();
            }
            toThrow.addSuppressed(e);
        }
        if (toThrow != null) {
            throw toThrow;
        }
        return result;
    }

    @Override
    public <T> T doParallel(Callable<T> foregroundTask, Callable<Void> backgroundTask) throws ParallelExecutionException {
        return this.doParallel(foregroundTask, backgroundTask, NOOP);
    }
}

