/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility;

import com.swirlds.common.Releasable;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;

public class RuntimeObjectRecord
implements Releasable {
    private boolean released = false;
    private final Consumer<RuntimeObjectRecord> cleanupAction;
    private final Instant creationTime;
    private final Object metadata;

    public RuntimeObjectRecord(Instant creationTime, Consumer<RuntimeObjectRecord> cleanupAction) {
        this(creationTime, cleanupAction, null);
    }

    public RuntimeObjectRecord(Instant creationTime, Consumer<RuntimeObjectRecord> cleanupAction, Object metadata) {
        this.creationTime = creationTime;
        this.cleanupAction = cleanupAction;
        this.metadata = metadata;
    }

    @Override
    public synchronized boolean release() {
        this.throwIfDestroyed();
        this.released = true;
        if (this.cleanupAction != null) {
            this.cleanupAction.accept(this);
        }
        return true;
    }

    @Override
    public synchronized boolean isDestroyed() {
        return this.released;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public Duration getAge(Instant now) {
        return Duration.between(this.creationTime, now);
    }

    public <T> T getMetadata() {
        return (T)this.metadata;
    }
}

