/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility;

import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.utility.CommonUtils;
import com.swirlds.common.utility.InvalidSemanticVersionException;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class SemanticVersion
implements Comparable<SemanticVersion>,
SelfSerializable {
    public static final SemanticVersion ZERO = new SemanticVersion(0, 0, 0, "", "");
    private static final String PERIOD = ".";
    private static final String DASH = "-";
    private static final String PLUS = "+";
    private static final Pattern SEMVER_PATTERN = Pattern.compile("^((\\d+)\\.(\\d+)\\.(\\d+))(?:-([\\dA-Za-z]+(?:\\.[\\dA-Za-z]+)*))?(?:\\+([\\dA-Za-z\\-]+(?:\\.[\\dA-Za-z\\-]+)*))?$");
    private static final int MAX_STRING_LENGTH = 1000;
    private static final long CLASS_ID = -6458487196888687168L;
    private int major;
    private int minor;
    private int patch;
    private String prerelease;
    private String build;

    public SemanticVersion() {
    }

    public SemanticVersion(int major, int minor, int patch, String prerelease, String build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        if (prerelease != null && prerelease.length() > 1000) {
            throw new IllegalArgumentException("Invalid length for prerelease, max is 1000");
        }
        this.prerelease = prerelease;
        if (build != null && build.length() > 1000) {
            throw new IllegalArgumentException("Invalid length for build, max is 1000");
        }
        this.build = build;
    }

    public static SemanticVersion parse(String version) {
        CommonUtils.throwArgNull(version, "version");
        Matcher matcher = SEMVER_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new InvalidSemanticVersionException(String.format("The supplied version '%s' is not a valid semantic version", version));
        }
        try {
            int major = Integer.parseInt(matcher.group(2));
            int minor = Integer.parseInt(matcher.group(3));
            int patch = Integer.parseInt(matcher.group(4));
            String prerelease = CommonUtils.nullToBlank(matcher.group(5));
            String build = CommonUtils.nullToBlank(matcher.group(6));
            return new SemanticVersion(major, minor, patch, prerelease, build);
        }
        catch (NumberFormatException e) {
            throw new InvalidSemanticVersionException(String.format("The supplied version '%s' is not a valid semantic version", version), e);
        }
    }

    @Override
    public int compareTo(SemanticVersion that) {
        if (this == that) {
            return 0;
        }
        return new CompareToBuilder().append(this.major, that.major).append(this.minor, that.minor).append(this.patch, that.patch).append((Object)this.prerelease, (Object)that.prerelease).append((Object)this.build, (Object)that.build).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SemanticVersion)) {
            return false;
        }
        SemanticVersion that = (SemanticVersion)o;
        return new EqualsBuilder().append(this.major, that.major).append(this.minor, that.minor).append(this.patch, that.patch).append((Object)this.prerelease, (Object)that.prerelease).append((Object)this.build, (Object)that.build).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.major).append(this.minor).append(this.patch).append((Object)this.prerelease).append((Object)this.build).toHashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%d", this.major())).append(PERIOD).append(String.format("%d", this.minor())).append(PERIOD).append(String.format("%d", this.patch()));
        if (this.prerelease() != null && !this.prerelease().isBlank()) {
            builder.append(DASH).append(this.prerelease());
        }
        if (this.build() != null && !this.build().isBlank()) {
            builder.append(PLUS).append(this.build());
        }
        return builder.toString();
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    public String prerelease() {
        return this.prerelease;
    }

    public String build() {
        return this.build;
    }

    @Override
    public long getClassId() {
        return -6458487196888687168L;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeInt(this.major);
        out.writeInt(this.minor);
        out.writeInt(this.patch);
        out.writeNormalisedString(this.prerelease);
        out.writeNormalisedString(this.build);
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.major = in.readInt();
        this.minor = in.readInt();
        this.patch = in.readInt();
        this.prerelease = in.readNormalisedString(1000);
        this.build = in.readNormalisedString(1000);
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

