/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class TextTable {
    private static final char PADDING = ' ';
    private static final char CROSS_JUNCTION = '\u253c';
    private static final char CROSS_HEADER_JUNCTION = '\u2547';
    private static final char LEFT_JUNCTION = '\u2520';
    private static final char LEFT_HEADER_JUNCTION = '\u2523';
    private static final char RIGHT_JUNCTION = '\u2528';
    private static final char RIGHT_HEADER_JUNCTION = '\u252b';
    private static final char BOTTOM_JUNCTION = '\u2537';
    private static final char TOP_JUNCTION = '\u252f';
    private static final char THICK_TOP_JUNCTION = '\u2533';
    private static final char TOP_LEFT_CORNER = '\u250f';
    private static final char TOP_RIGHT_CORNER = '\u2513';
    private static final char BOTTOM_LEFT_CORNER = '\u2517';
    private static final char BOTTOM_RIGHT_CORNER = '\u251b';
    private static final char HORIZONTAL_BAR = '\u2500';
    private static final char THICK_HORIZONTAL_BAR = '\u2501';
    private static final char VERTICAL_BAR = '\u2502';
    private static final char THICK_VERTICAL_BAR = '\u2503';
    private static final char NEWLINE = '\n';
    private final String title;
    private final List<String> headers = new ArrayList<String>();
    private final List<List<String>> rows = new ArrayList<List<String>>();

    public TextTable(String title, Object ... headers) {
        this.title = title;
        if (headers != null) {
            for (Object header : headers) {
                this.headers.add(header.toString());
            }
        }
    }

    public static void addRepeated(StringBuilder sb, String string, int count) {
        sb.append(String.valueOf(string).repeat(Math.max(0, count)));
    }

    public static void addRepeated(StringBuilder sb, char c, int count) {
        sb.append(String.valueOf(c).repeat(Math.max(0, count)));
    }

    public static void leftPad(StringBuilder sb, String string, char padding, int width) {
        sb.append(string);
        TextTable.addRepeated(sb, padding, width - string.length());
    }

    public static void rightPad(StringBuilder sb, String string, char padding, int width) {
        TextTable.addRepeated(sb, padding, width - string.length());
        sb.append(string);
    }

    public static void centerPad(StringBuilder sb, String string, char padding, int width) {
        int leftPadding = (width - string.length()) / 2;
        int rightPadding = width - string.length() - leftPadding;
        TextTable.addRepeated(sb, padding, leftPadding);
        sb.append(string);
        TextTable.addRepeated(sb, padding, rightPadding);
    }

    public static String commaSeparatedValue(long value) {
        if (value == 0L) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        long runningValue = value;
        if (value < 0L) {
            sb.append("-");
            runningValue *= -1L;
        }
        LinkedList<Integer> parts = new LinkedList<Integer>();
        while (runningValue > 0L) {
            parts.add(0, (int)(runningValue % 1000L));
            runningValue /= 1000L;
        }
        for (int index = 0; index < parts.size(); ++index) {
            if (index == 0) {
                sb.append(parts.get(index));
            } else {
                String digits = Integer.toString((Integer)parts.get(index));
                TextTable.rightPad(sb, digits, '0', 3);
            }
            if (index + 1 >= parts.size()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public TextTable addRow(Object ... row) {
        if (row != null) {
            ArrayList<String> rowString = new ArrayList<String>();
            for (Object o : row) {
                rowString.add(o.toString());
            }
            this.rows.add(rowString);
        }
        return this;
    }

    private static void expandColumnWidthsForRow(List<Integer> columnWidths, List<String> row) {
        for (int column = 0; column < row.size(); ++column) {
            int columnWidth = row.get(column).length();
            if (columnWidths.size() <= column) {
                columnWidths.add(columnWidth);
                continue;
            }
            columnWidths.set(column, Math.max(columnWidths.get(column), columnWidth));
        }
    }

    private List<Integer> computeColumnWidths() {
        ArrayList<Integer> columnWidths = new ArrayList<Integer>();
        TextTable.expandColumnWidthsForRow(columnWidths, this.headers);
        for (List<String> row : this.rows) {
            TextTable.expandColumnWidthsForRow(columnWidths, row);
        }
        return columnWidths;
    }

    private static void generateTop(StringBuilder sb, int columnWidthSum, int columnCount) {
        sb.append('\u250f');
        TextTable.addRepeated(sb, '\u2501', columnWidthSum + columnCount * 3 - 1);
        sb.append('\u2513').append('\n');
    }

    private void generateTitleLine(StringBuilder sb, int columnWidthSum, int columnCount) {
        sb.append('\u2503');
        sb.append(' ');
        TextTable.centerPad(sb, this.title, ' ', columnWidthSum + columnCount * 3 - 3);
        sb.append(' ');
        sb.append('\u2503').append('\n');
    }

    private static void generateLineBelowTitle(StringBuilder sb, List<Integer> columnWidths) {
        sb.append('\u2523');
        for (int columnIndex = 0; columnIndex < columnWidths.size(); ++columnIndex) {
            TextTable.addRepeated(sb, '\u2501', columnWidths.get(columnIndex) + 2);
            if (columnIndex + 1 >= columnWidths.size()) continue;
            sb.append('\u2533');
        }
        sb.append('\u252b').append('\n');
    }

    private static void generateLineBelowTitleNoHeaders(StringBuilder sb, List<Integer> columnWidths) {
        sb.append('\u2523');
        for (int columnIndex = 0; columnIndex < columnWidths.size(); ++columnIndex) {
            TextTable.addRepeated(sb, '\u2501', columnWidths.get(columnIndex) + 2);
            if (columnIndex + 1 >= columnWidths.size()) continue;
            sb.append('\u252f');
        }
        sb.append('\u252b').append('\n');
    }

    private void generateHeaderRow(StringBuilder sb, List<Integer> columnWidths) {
        sb.append('\u2503');
        for (int columnIndex = 0; columnIndex < columnWidths.size(); ++columnIndex) {
            sb.append(' ');
            String header = this.headers.size() > columnIndex ? this.headers.get(columnIndex) : "";
            TextTable.leftPad(sb, header, ' ', columnWidths.get(columnIndex));
            sb.append(' ');
            sb.append('\u2503');
        }
        sb.append('\n');
    }

    private static void generateLineBelowHeaders(StringBuilder sb, List<Integer> columnWidths) {
        sb.append('\u2523');
        for (int columnIndex = 0; columnIndex < columnWidths.size(); ++columnIndex) {
            TextTable.addRepeated(sb, '\u2501', columnWidths.get(columnIndex) + 2);
            if (columnIndex + 1 >= columnWidths.size()) continue;
            sb.append('\u2547');
        }
        sb.append('\u252b').append('\n');
    }

    private static void generateDataRow(StringBuilder sb, List<String> row, List<Integer> columnWidths) {
        sb.append('\u2503');
        for (int columnIndex = 0; columnIndex < columnWidths.size(); ++columnIndex) {
            sb.append(' ');
            String value = columnIndex < row.size() ? row.get(columnIndex) : "";
            TextTable.leftPad(sb, value, ' ', columnWidths.get(columnIndex));
            sb.append(' ');
            if (columnIndex + 1 >= columnWidths.size()) continue;
            sb.append('\u2502');
        }
        sb.append('\u2503');
        sb.append('\n');
    }

    private static void generateLineBelowDataRow(StringBuilder sb, List<Integer> columnWidths) {
        sb.append('\u2520');
        for (int columnIndex = 0; columnIndex < columnWidths.size(); ++columnIndex) {
            TextTable.addRepeated(sb, '\u2500', columnWidths.get(columnIndex) + 2);
            if (columnIndex + 1 >= columnWidths.size()) continue;
            sb.append('\u253c');
        }
        sb.append('\u2528').append('\n');
    }

    private void generateRows(StringBuilder sb, List<Integer> columnWidths) {
        for (int rowIndex = 0; rowIndex < this.rows.size(); ++rowIndex) {
            TextTable.generateDataRow(sb, this.rows.get(rowIndex), columnWidths);
            if (rowIndex + 1 >= this.rows.size()) continue;
            TextTable.generateLineBelowDataRow(sb, columnWidths);
        }
    }

    private static void generateBottomLine(StringBuilder sb, List<Integer> columnWidths) {
        sb.append('\u2517');
        for (int columnIndex = 0; columnIndex < columnWidths.size(); ++columnIndex) {
            TextTable.addRepeated(sb, '\u2501', columnWidths.get(columnIndex) + 2);
            if (columnIndex + 1 >= columnWidths.size()) continue;
            sb.append('\u2537');
        }
        sb.append('\u251b');
    }

    public void addToStringBuilder(StringBuilder sb) {
        List<Integer> columnWidths = this.computeColumnWidths();
        int columnWidthSum = 0;
        for (int columnWidth : columnWidths) {
            columnWidthSum += columnWidth;
        }
        int columnCount = columnWidths.size();
        int minimumWidth = this.title.length() + columnCount * 3 - 3;
        if (columnWidthSum < minimumWidth) {
            int expansion = minimumWidth - columnWidthSum;
            columnWidthSum += expansion;
            int lastIndex = columnWidths.size() - 1;
            columnWidths.set(lastIndex, columnWidths.get(lastIndex) + expansion);
        }
        TextTable.generateTop(sb, columnWidthSum, columnCount);
        this.generateTitleLine(sb, columnWidthSum, columnCount);
        if (this.headers.isEmpty()) {
            TextTable.generateLineBelowTitleNoHeaders(sb, columnWidths);
        } else {
            TextTable.generateLineBelowTitle(sb, columnWidths);
            this.generateHeaderRow(sb, columnWidths);
            TextTable.generateLineBelowHeaders(sb, columnWidths);
        }
        this.generateRows(sb, columnWidths);
        TextTable.generateBottomLine(sb, columnWidths);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.addToStringBuilder(sb);
        return sb.toString();
    }
}

