
Run from repo sdk directory
===========================

* for signing single file:

```
java -DlogConfig={path of log4j2-signing-tool.xml} -Dfile={the file to be signed} -Dkey={.pfx private key file path}  -Dalias=s-{node alias name} -DdestDir={the directory of the generated signature file} -Dpassword=password -classpath swirlds.jar:data/lib/* com.swirlds.common.signingtool.FileSignTool
```

* for generating signature files for all .rcd/.evts/.csv/.pb files in a directory:

```
java -DlogConfig={path of log4j2-signing-tool.xml} -Ddir={the directory which contains .rcd/.evts/.csv/.pb files needs to be signed} -Dkey={.pfx private key file path}  -Dalias=s-{node alias name} -DdestDir={the directory of the generated signature file} -Dpassword=password -classpath swirlds.jar:data/lib/* com.swirlds.common.signingtool.FileSignTool
```

Note
====

* This tool generates version5 signature files for *.evts EventStream file, *.rcd RecordStream file. Please see [this doc](https://hederatest.sharepoint.com/:w:/r/sites/Engineering/_layouts/15/Doc.aspx?sourcedoc=%7Be24a2e92-797d-4e26-91b0-9fbb41c46ba0%7D&action=edit&wdPid=72a0e063) for format details.

* For *.csv / *.pb AccountBalance files or other files, this tool generates signature files with the following format:
    Name | Type (Bytes) | Description
    -- | -- | --
    File Hash Marker | byte | Value: 4
    File Hash | byte[48] | SHA384 hash of all bytes in the file to be signed
    Signature Marker | byte | Value: 3
    Length of Signature | int (4) | Byte size of the following signature bytes
    Signature | byte[] | Signature bytes

* Please check signingTool.log to see whether there are any error after signing

* Output signature file name are the same input file name with the following extension name:
	(1) ".evts_sig" for *.evts files ;
	(2) ".rcd_sig" for *.rcd files;
	(3) ".csv_sig" for *.csv files;
	(4) ".pb_sig" for *.pb files
	
* When parsing *.rcd RecordStream v5 file, HederaNode.jar file and `hapi-proto-*.jar` file should be in classPath. Besides, a .json file which denotes the record stream type should also be provided in this parameter `-DstreamTypeJson` .

	an example:
```
 java -DstreamTypeJson=streamType/recordStreamType.json -DlogConfig=log4j2-signing-tool.xml -Ddir=record0.0.3/ -Dkey=keys/private-alice.pfx  -Dalias=s-alice -DdestDir=./signingTool  -Dpassword=password -classpath ./apps/HederaNode.jar:./lib/* com.swirlds.common.signingtool.FileSignTool
```
   
* The `recordStreamType.json` used for parsing record stream files should match the RecordStreamType.java in hedera-services code which generates the record stream files to be signed. 
    A sample recordStreamType.json file for parsing record stream files generated by services 0.11.0:
    ```
    {
      "description": "records",
      "extension": "rcd",
      "sigExtension": "rcd_sig",
      "fileHeader": [5, 0, 11, 0],
      "sigFileHeader": [5]
    }
    ```

* When signing a directory with parameter `-Ddir` be set, the tool only generates signature files for .rcd/.evts/.csv/.pb files. Other file types can only be signed one file each time, with parameter `Dfile` be set.

