/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;

public final class StartupTime {
    private static final AtomicReference<Instant> startupTime = new AtomicReference<Object>(null);

    private StartupTime() {
    }

    public static void markStartupTime() {
        startupTime.compareAndSet(null, Instant.now());
    }

    public static Instant getStartupTime() {
        Instant time = startupTime.get();
        if (time == null) {
            throw new IllegalStateException("startup time not marked");
        }
        return time;
    }

    public static Duration getTimeSinceStartup() {
        return Duration.between(StartupTime.getStartupTime(), Instant.now());
    }
}

