/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.config;

import com.swirlds.common.constructable.URLClassLoaderWithLookup;
import com.swirlds.config.api.ConfigData;
import com.swirlds.config.api.ConfigurationBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class ConfigUtils {
    private ConfigUtils() {
    }

    @NonNull
    public static ConfigurationBuilder scanAndRegisterAllConfigTypes(@NonNull ConfigurationBuilder configurationBuilder) {
        return ConfigUtils.scanAndRegisterAllConfigTypes(configurationBuilder, Set.of());
    }

    @NonNull
    public static ConfigurationBuilder scanAndRegisterAllConfigTypes(@NonNull ConfigurationBuilder configurationBuilder, @NonNull Set<String> packagePrefixes) {
        Objects.requireNonNull(packagePrefixes, "packagePrefixes must not be null");
        return ConfigUtils.scanAndRegisterAllConfigTypes(configurationBuilder, packagePrefixes, Collections.emptyList());
    }

    @NonNull
    public static ConfigurationBuilder scanAndRegisterAllConfigTypes(@NonNull ConfigurationBuilder configurationBuilder, @NonNull Set<String> packagePrefixes, @NonNull List<URLClassLoaderWithLookup> additionalClassLoaders) {
        Objects.requireNonNull(configurationBuilder, "configurationBuilder must not be null");
        ConfigUtils.loadAllConfigDataRecords(packagePrefixes, additionalClassLoaders).forEach(arg_0 -> ((ConfigurationBuilder)configurationBuilder).withConfigDataType(arg_0));
        return configurationBuilder;
    }

    @NonNull
    private static Set<Class<? extends Record>> loadAllConfigDataRecords(@NonNull Set<String> packagePrefixes, @NonNull List<URLClassLoaderWithLookup> additionalClassLoaders) {
        Objects.requireNonNull(packagePrefixes, "packagePrefix must not be null");
        Objects.requireNonNull(additionalClassLoaders, "additionalClassLoaders must not be null");
        ClassGraph classGraph = new ClassGraph().enableAnnotationInfo();
        if (!packagePrefixes.isEmpty()) {
            classGraph.whitelistPackages(packagePrefixes.toArray(new String[0]));
        }
        for (URLClassLoaderWithLookup classloader : additionalClassLoaders) {
            classGraph.addClassLoader((ClassLoader)classloader);
        }
        try (ScanResult result = classGraph.scan();){
            ClassInfoList classInfos = result.getClassesWithAnnotation(ConfigData.class.getName());
            Set<Class<? extends Record>> set = classInfos.stream().map(classInfo -> classInfo.loadClass()).filter(clazz -> clazz.isRecord()).map(clazz -> clazz).collect(Collectors.toSet());
            return set;
        }
    }
}

