/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.config.export;

import com.swirlds.common.config.reflection.ConfigReflectionUtils;
import com.swirlds.common.utility.CommonUtils;
import com.swirlds.config.api.Configuration;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.RecordComponent;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class ConfigExport {
    private ConfigExport() {
    }

    public static void printConfig(Configuration configuration, Consumer<String> lineConsumer) {
        CommonUtils.throwArgNull(configuration, "configuration");
        CommonUtils.throwArgNull(lineConsumer, "lineConsumer");
        Map<String, Object> recordProperties = ConfigExport.getPropertiesForConfigDataRecords(configuration);
        HashMap nonRecordProperties = new HashMap();
        configuration.getPropertyNames().filter(name -> !recordProperties.containsKey(name)).forEach(name -> nonRecordProperties.put(name, configuration.getValue(name)));
        Set<String> allConfigNames = ConfigExport.combine(recordProperties.keySet(), nonRecordProperties.keySet());
        Set<Object> allConfigValues = ConfigExport.combine(recordProperties.values(), nonRecordProperties.values());
        int maxNameLength = ConfigExport.getMaxPropertyLength(allConfigNames);
        int maxValueLength = ConfigExport.getMaxPropertyLength(allConfigValues);
        recordProperties.keySet().stream().sorted().forEach(name -> {
            Object value = recordProperties.get(name);
            String line = ConfigExport.buildLine(name, value, maxNameLength, maxValueLength, "  [USED IN RECORD]");
            lineConsumer.accept(line);
        });
        nonRecordProperties.keySet().stream().sorted().forEach(name -> {
            Object value = nonRecordProperties.get(name);
            String line = ConfigExport.buildLine(name, value, maxNameLength, maxValueLength, "  [NOT USED IN RECORD]");
            lineConsumer.accept(line);
        });
    }

    private static <T> Set<T> combine(Collection<T> set1, Collection<T> set2) {
        return Stream.concat(set1.stream(), set2.stream()).collect(Collectors.toSet());
    }

    private static String buildLine(String name, Object value, int maxNameLength, int maxValueLength, String suffix) {
        return name + ConfigExport.createSpaces(name, maxNameLength) + " -> " + value + ConfigExport.createSpaces(value.toString(), maxValueLength) + suffix;
    }

    public static void printConfig(Configuration configuration, OutputStream printStream) throws IOException {
        CommonUtils.throwArgNull(configuration, "configuration");
        CommonUtils.throwArgNull(printStream, "printStream");
        StringBuilder builder = new StringBuilder();
        ConfigExport.printConfig(configuration, (String line) -> builder.append((String)line).append(System.lineSeparator()));
        printStream.write(builder.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static void addConfigContents(Configuration configuration, StringBuilder builder) {
        CommonUtils.throwArgNull(configuration, "configuration");
        CommonUtils.throwArgNull(builder, "builder");
        ConfigExport.printConfig(configuration, (String line) -> builder.append((String)line).append(System.lineSeparator()));
    }

    private static Map<String, Object> getPropertiesForConfigDataRecords(Configuration configuration) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        configuration.getConfigDataTypes().forEach(configDataType -> ConfigExport.putValuesInMap(configuration.getConfigData(configDataType), map));
        return map;
    }

    private static void putValuesInMap(Record configData, Map<String, Object> map) {
        Class<?> configDataType = configData.getClass();
        String propertyNamePrefix = ConfigReflectionUtils.getNamePrefixForConfigDataRecord(configDataType);
        Arrays.stream(configDataType.getRecordComponents()).forEach(component -> {
            String name = ConfigReflectionUtils.getPropertyNameForConfigDataProperty(propertyNamePrefix, component);
            Object value = ConfigExport.getComponentValue(configData, component);
            map.put(name, value);
        });
    }

    private static Object getComponentValue(Record configData, RecordComponent component) {
        try {
            return component.getAccessor().invoke((Object)configData, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not access config value for record type '" + component.getClass() + "." + component.getAccessor().getName() + "'", e);
        }
    }

    private static String createSpaces(String value, int maxLength) {
        return IntStream.range(value.length(), maxLength).mapToObj(i -> " ").reduce("", (a, b) -> a + b);
    }

    private static int getMaxPropertyLength(Set<?> values) {
        return values.stream().map(String::valueOf).mapToInt(String::length).max().orElse(0);
    }
}

