/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.config.sources;

import com.swirlds.common.config.sources.MappedConfigSource;
import com.swirlds.common.utility.CommonUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record ConfigMapping(@NonNull String mappedName, @NonNull String originalName) {
    private static final Logger logger = LogManager.getLogger(MappedConfigSource.class);

    public ConfigMapping {
        CommonUtils.throwArgBlank(mappedName, "mappedName");
        CommonUtils.throwArgBlank(originalName, "originalName");
        if (Objects.equals(originalName, mappedName)) {
            throw new IllegalArgumentException("originalName and mappedName are the same (%s)! Will not create an mappedName".formatted(mappedName));
        }
    }

    @Override
    public String toString() {
        return "'" + this.mappedName + "'<->'" + this.originalName + "'";
    }
}

